/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.properties;

import io.deephaven.properties.PropertyVisitor;

public enum PropertyVisitorError implements PropertyVisitor
{
    INSTANCE;

    private static final int MAX_UNTRUNCATED_STRING_LENGTH = 128;

    @Override
    public void visit(String key, String value) {
        if (value.length() > 128) {
            throw new IllegalStateException(String.format("Unexpected key/string-value: %s='%s...' (truncated)", key, value.substring(0, 128)));
        }
        throw new IllegalStateException(String.format("Unexpected key/string-value: %s='%s'", key, value));
    }

    @Override
    public void visit(String key, int value) {
        throw new IllegalStateException(String.format("Unexpected key/int-value: %s=%d", key, value));
    }

    @Override
    public void visit(String key, long value) {
        throw new IllegalStateException(String.format("Unexpected key/long-value: %s=%dL", key, value));
    }

    @Override
    public void visit(String key, boolean value) {
        throw new IllegalStateException(String.format("Unexpected key/boolean-value: %s=%b", key, value));
    }
}

