/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.properties;

import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import java.util.Objects;

class PropertyVisitorPrefixed
implements PropertyVisitor {
    private final String prefix;
    private final PropertyVisitor delegate;

    PropertyVisitorPrefixed(String prefix, PropertyVisitor delegate) {
        this.prefix = Objects.requireNonNull(prefix, "prefix");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty prefix");
        }
    }

    private String prefix(String key) {
        return this.prefix + key;
    }

    @Override
    public void visit(String key, String value) {
        this.delegate.visit(this.prefix(key), value);
    }

    @Override
    public void visit(String key, int value) {
        this.delegate.visit(this.prefix(key), value);
    }

    @Override
    public void visit(String key, long value) {
        this.delegate.visit(this.prefix(key), value);
    }

    @Override
    public void visit(String key, boolean value) {
        this.delegate.visit(this.prefix(key), value);
    }

    @Override
    public void visitProperties(String key, PropertySet properties) {
        new PropertyVisitorPrefixed(this.prefix + key + ".", this.delegate).visitProperties(properties);
    }
}

