/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.properties;

import io.deephaven.properties.PropertyVisitor;
import java.util.Objects;

class PropertyVisitorStripPrefix
implements PropertyVisitor {
    private final String prefix;
    private final PropertyVisitor delegate;

    PropertyVisitorStripPrefix(String prefix, PropertyVisitor delegate) {
        this.prefix = Objects.requireNonNull(prefix, "prefix");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty prefix");
        }
    }

    private String strip(String key) {
        if (!key.startsWith(this.prefix)) {
            throw new IllegalArgumentException(String.format("Key '%s' does not start with prefix '%s'", key, this.prefix));
        }
        return key.substring(this.prefix.length());
    }

    @Override
    public void visit(String key, String value) {
        this.delegate.visit(this.strip(key), value);
    }

    @Override
    public void visit(String key, int value) {
        this.delegate.visit(this.strip(key), value);
    }

    @Override
    public void visit(String key, long value) {
        this.delegate.visit(this.strip(key), value);
    }

    @Override
    public void visit(String key, boolean value) {
        this.delegate.visit(this.strip(key), value);
    }
}

