/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.datastructures.util;

import io.deephaven.base.verify.Require;
import io.deephaven.base.verify.RequirementFailure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CollectionUtil {
    public static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    public static final short[] ZERO_LENGTH_SHORT_ARRAY = new short[0];
    public static final int[] ZERO_LENGTH_INT_ARRAY = new int[0];
    public static final int[][] ZERO_LENGTH_INT_ARRAY_ARRAY = new int[0][];
    public static final long[] ZERO_LENGTH_LONG_ARRAY = new long[0];
    public static final float[] ZERO_LENGTH_FLOAT_ARRAY = new float[0];
    public static final double[] ZERO_LENGTH_DOUBLE_ARRAY = new double[0];
    public static final double[][] ZERO_LENGTH_DOUBLE_ARRAY_ARRAY = new double[0][];
    public static final Object[] ZERO_LENGTH_OBJECT_ARRAY = new Object[0];
    public static final String[] ZERO_LENGTH_STRING_ARRAY = new String[0];
    public static final String[][] ZERO_LENGTH_STRING_ARRAY_ARRAY = new String[0][];
    public static final Set UNIVERSAL_SET = new UniversalSet();

    public static <K, V> Map<K, V> unmodifiableMapFromArray(Class<K> typeK, Class<V> typeV, Object ... data) {
        try {
            return Collections.unmodifiableMap(CollectionUtil.mapFromArray(typeK, typeV, data));
        }
        catch (RequirementFailure e) {
            throw e.adjustForDelegatingMethod();
        }
    }

    public static <K, V> Map<K, V> unmodifiableInvertMap(Map<V, K> sourceMap) {
        try {
            return Collections.unmodifiableMap(CollectionUtil.invertMap(sourceMap));
        }
        catch (RequirementFailure e) {
            throw e.adjustForDelegatingMethod();
        }
    }

    public static <E> Set<E> unmodifiableSetFromArray(E ... data) {
        try {
            return Collections.unmodifiableSet(CollectionUtil.setFromArray(data));
        }
        catch (RequirementFailure e) {
            throw e.adjustForDelegatingMethod();
        }
    }

    public static <K, V> Map<K, V> mapFromArray(Class<K> typeK, Class<V> typeV, Object ... data) {
        return CollectionUtil.mapFromArray(typeK, typeV, false, data);
    }

    public static <K, V> Map<K, V> mapFromArray(Class<K> typeK, Class<V> typeV, boolean allowDuplicateKeys, Object ... data) {
        Require.neqNull((Object)data, (String)"data");
        Require.requirement((0 == data.length % 2 ? 1 : 0) != 0, (String)"0==data.length%2");
        Map<Object, Object> map = CollectionUtil.newSizedLinkedHashMap(data.length / 2);
        for (int nIndex = 0; nIndex < data.length; nIndex += 2) {
            Object value;
            Object key = data[nIndex];
            if (null != key) {
                Require.instanceOf((Object)key, (String)"key", typeK);
            }
            if (!allowDuplicateKeys) {
                Require.requirement((false == map.containsKey(key) ? 1 : 0) != 0, (String)"false==map.containsKey(data[nIndex])", (Object)key, (String)"data[nIndex]");
            }
            if (null != (value = data[nIndex + 1])) {
                Require.instanceOf((Object)value, (String)"value", typeV);
            }
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> Map<K, V> invertMap(Map<V, K> sourceMap) {
        Require.neqNull(sourceMap, (String)"sourceMap");
        Map<K, V> targetMap = CollectionUtil.newSizedLinkedHashMap(sourceMap.size());
        for (Map.Entry<V, K> entry : sourceMap.entrySet()) {
            K key = entry.getValue();
            V value = entry.getKey();
            Require.requirement((false == targetMap.containsKey(key) ? 1 : 0) != 0, (String)"false==targetMap.containsKey(key)", key, (String)"key");
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static <E> Set<E> setFromArray(E ... data) {
        Require.neqNull(data, (String)"data");
        Set<E> set = CollectionUtil.newSizedLinkedHashSet(data.length);
        for (E elem : data) {
            Require.requirement((boolean)set.add(elem), (String)"set.add(elem)");
        }
        return set;
    }

    public static <TYPE> Set<TYPE> setFromArray(@NotNull Class<TYPE> type, Object ... data) {
        Set<Object> set = CollectionUtil.newSizedLinkedHashSet(data.length);
        for (Object elem : data) {
            Require.requirement((elem == null || type.isInstance(elem) ? 1 : 0) != 0, (String)"elem == null || type.isInstance(elem)");
            Require.requirement((boolean)set.add(elem), (String)"set.add((TYPE)elem)");
        }
        return set;
    }

    public static <E> List<E> listFromArray(E ... data) {
        Require.neqNull(data, (String)"data");
        ArrayList<E> list = new ArrayList<E>(data.length);
        for (E elem : data) {
            list.add(elem);
        }
        return list;
    }

    public static <K, V> Map<K, V> newSizedHashMap(int nEntries) {
        return new HashMap((nEntries + 1) * 4 / 3);
    }

    public static <K, V> Map<K, V> newSizedLinkedHashMap(int nEntries) {
        return new LinkedHashMap((nEntries + 1) * 4 / 3);
    }

    public static <E> Set<E> newSizedHashSet(int nEntries) {
        return new HashSet((nEntries + 1) * 4 / 3);
    }

    public static <E> Set<E> newSizedLinkedHashSet(int nEntries) {
        return new LinkedHashSet((nEntries + 1) * 4 / 3);
    }

    public static double[] convertDoublesToPrimitiveArray(Collection<Double> collection) {
        double[] array = new double[collection.size()];
        Iterator<Double> iter = collection.iterator();
        for (int nIndex = 0; nIndex < array.length; ++nIndex) {
            array[nIndex] = iter.next();
        }
        return array;
    }

    public static int[] convertIntegersToPrimitiveArray(Collection<Integer> collection) {
        int[] array = new int[collection.size()];
        Iterator<Integer> iter = collection.iterator();
        for (int nIndex = 0; nIndex < array.length; ++nIndex) {
            array[nIndex] = iter.next();
        }
        return array;
    }

    public static long[] convertLongsToPrimitiveArray(Collection<Long> collection) {
        long[] array = new long[collection.size()];
        Iterator<Long> iter = collection.iterator();
        for (int nIndex = 0; nIndex < array.length; ++nIndex) {
            array[nIndex] = iter.next();
        }
        return array;
    }

    public static <E> void shuffle(E[] elems, Random random) {
        for (int nIndex = elems.length; nIndex > 1; --nIndex) {
            int nSwapWith;
            int nChoice = random.nextInt(nIndex);
            if (nChoice == (nSwapWith = nIndex - 1)) continue;
            E temp = elems[nSwapWith];
            elems[nSwapWith] = elems[nChoice];
            elems[nChoice] = temp;
        }
    }

    public static <E> boolean containsNull(E[] elems) {
        for (E e : elems) {
            if (e != null) continue;
            return true;
        }
        return false;
    }

    public static <T> Set<T> universalSet() {
        return UNIVERSAL_SET;
    }

    private static class UniversalSet<T>
    implements Set<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private UniversalSet() {
        }

        private Object readResolve() {
            return UNIVERSAL_SET;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }
    }
}

