/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.datastructures.util;

import java.util.Date;

public class HashCodeUtil {
    public static int toHashCode(double val) {
        if (Double.isNaN(val)) {
            return 0;
        }
        long t = Double.doubleToLongBits(val);
        return (int)(t ^ t >>> 32);
    }

    public static int toHashCode(long val) {
        return (int)(val ^ val >>> 32);
    }

    public static int toHashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static int combineHashCodes(Object ... values) {
        return HashCodeUtil.createHashCode(values);
    }

    public static int createHashCode(Object[] values) {
        int result = 37;
        for (int i = 0; i < values.length; ++i) {
            int hash;
            if (values[i] == null) {
                hash = 0;
            } else {
                Class<?> type = values[i].getClass();
                if (type == String.class) {
                    String str = (String)values[i];
                    hash = str != null ? str.hashCode() : 0;
                } else if (type == Integer.class) {
                    hash = (Integer)values[i];
                } else if (type == Double.class) {
                    double val = (Double)values[i];
                    if (Double.isNaN(val)) {
                        hash = 0;
                    } else {
                        long t = Double.doubleToLongBits(val);
                        hash = (int)(t ^ t >>> 32);
                    }
                } else if (type == Long.class) {
                    long t = (Long)values[i];
                    hash = (int)(t ^ t >>> 32);
                } else if (type == Date.class) {
                    long t = ((Date)values[i]).getTime();
                    hash = (int)(t ^ t >>> 32);
                } else {
                    hash = type == Byte.class ? (int)((Byte)values[i]).byteValue() : (type == Boolean.class ? values[i].hashCode() : (type.isEnum() ? ((Enum)values[i]).ordinal() : values[i].hashCode()));
                }
            }
            result = result * 17 + hash;
        }
        return result;
    }
}

