/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.RingBuffer;
import io.deephaven.io.logger.LogBufferRecord;
import io.deephaven.io.logger.LogBufferRecordListener;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

public class LogBuffer
implements LogBufferRecordListener {
    public static final int DEFAULT_HISTORY_SIZE = 1023;
    protected final RingBuffer<LogBufferRecord> history;
    private final CopyOnWriteArraySet<LogBufferRecordListener> listeners = new CopyOnWriteArraySet();

    public LogBuffer(int historySize) {
        this.history = new RingBuffer(historySize);
    }

    public LogBuffer() {
        this(1023);
    }

    public int capacity() {
        return this.history.capacity();
    }

    public synchronized void clear() {
        this.history.clear();
    }

    public synchronized LogBufferRecord recordInternal(@NotNull LogBufferRecord record) {
        for (LogBufferRecordListener listener : this.listeners) {
            listener.record(record);
        }
        return (LogBufferRecord)this.history.addOverwrite((Object)record);
    }

    @Override
    public synchronized void record(@NotNull LogBufferRecord record) {
        this.recordInternal(record);
    }

    public synchronized void subscribe(LogBufferRecordListener listener) {
        this.listeners.add(listener);
        this.history.forEach(listener::record);
    }

    public synchronized void unsubscribe(LogBufferRecordListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized int subscriberCount() {
        return this.listeners.size();
    }
}

