/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.log.LogOutput;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.logger.LogBuffer;
import io.deephaven.io.logger.LogBufferRecord;
import io.deephaven.io.streams.ByteBufferOutputStream;
import io.deephaven.io.streams.SimpleByteBufferSink;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class LogBufferInterceptor
extends LogBuffer
implements LogSink.Interceptor<LogEntry> {
    public static final int RECORD_INITIAL_DATA_SIZE = 256;
    private LogBufferRecord next;

    public LogBufferInterceptor(int historySize) {
        super(historySize);
    }

    public LogBufferInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void element(@NotNull LogEntry e, @NotNull LogOutput output) throws IOException {
        if (e.getLevel() instanceof LogLevel.MailLevel) {
            return;
        }
        LogBufferInterceptor logBufferInterceptor = this;
        synchronized (logBufferInterceptor) {
            if (this.next == null) {
                this.next = new LogBufferRecord();
                this.next.setData(ByteBuffer.allocate(256));
            }
            this.next.setTimestampMicros(e.getTimestampMicros());
            this.next.setLevel(e.getLevel());
            this.next.getData().clear();
            SimpleByteBufferSink sink = new SimpleByteBufferSink(this.next.getData());
            ByteBufferOutputStream stream = new ByteBufferOutputStream(this.next.getData(), sink);
            try {
                for (int bi = 0; bi < output.getBufferCount(); ++bi) {
                    ByteBuffer outputBuffer = output.getBuffer(bi);
                    int initialPosition = outputBuffer.position();
                    int initialLimit = outputBuffer.limit();
                    stream.write(output.getBuffer(bi));
                    outputBuffer.limit(initialLimit).position(initialPosition);
                }
                stream.close();
            }
            catch (IOException x) {
                throw new IOException("Unexpected IOException while formatting LogBuffer Record", x);
            }
            ByteBuffer resultData = sink.getBuffer();
            resultData.flip();
            this.next.setData(resultData);
            LogBufferRecord removed = this.history.isFull() ? (LogBufferRecord)this.history.remove() : null;
            this.record(this.next);
            this.next = removed;
        }
    }
}

