/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import io.deephaven.base.verify.Require;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class BufferedChannelReader {
    private final String filename;
    private final int blockSize;
    private final int readSize;
    private ByteBuffer bb;
    private ReadableByteChannel channel;
    private int read;
    private int limit;

    public BufferedChannelReader(String filename, int blockSize, int readSize) {
        Require.leq((int)blockSize, (String)"blockSize", (int)readSize, (String)"readSize");
        this.filename = filename;
        this.blockSize = blockSize;
        this.readSize = readSize;
    }

    public ByteBuffer readNext() throws IOException {
        if (this.bb == null) {
            this.bb = ByteBuffer.allocate(this.readSize);
            this.bb.flip();
            this.channel = new FileInputStream(this.filename).getChannel();
        }
        this.bb.limit(this.limit);
        if (this.read != -1 && this.bb.remaining() < this.blockSize) {
            this.bb.compact();
            this.read = this.channel.read(this.bb);
            this.bb.flip();
        }
        this.limit = this.bb.limit();
        return this.bb;
    }

    public ByteBuffer getBb() {
        return this.bb;
    }

    public int getRead() {
        return this.read;
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }
}

