/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;

public class MultiFileInputStream
extends InputStream {
    private final DecoratedInputStream[] inputStreams;
    private int currentStream = -1;

    public MultiFileInputStream(DecoratedInputStream[] inputStreams) {
        this.inputStreams = inputStreams;
    }

    @Override
    public int read() throws IOException {
        if (this.inputStreams.length == 0 || this.currentStream >= this.inputStreams.length) {
            return -1;
        }
        if (this.currentStream < 0) {
            ++this.currentStream;
        }
        int result = this.inputStreams[this.currentStream].inputStream.read();
        while (result == -1) {
            ++this.currentStream;
            if (this.currentStream < this.inputStreams.length) {
                result = this.read();
                continue;
            }
            return -1;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.inputStreams.length == 0 || this.currentStream >= this.inputStreams.length) {
            return -1;
        }
        if (this.currentStream < 0) {
            ++this.currentStream;
        }
        int result = 0;
        do {
            int readBytes;
            if ((readBytes = this.inputStreams[this.currentStream].inputStream.read(b, off, len)) >= 0) {
                len -= readBytes;
                off += readBytes;
                result += readBytes;
            }
            if (len <= 0) continue;
            ++this.currentStream;
            if (this.currentStream < this.inputStreams.length) continue;
            if (result == 0) {
                return -1;
            }
            return result;
        } while (len > 0);
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        IOException caughtException = null;
        for (DecoratedInputStream is : this.inputStreams) {
            try {
                is.inputStream.close();
            }
            catch (IOException e) {
                caughtException = e;
            }
        }
        if (caughtException != null) {
            throw caughtException;
        }
    }

    @Nullable
    public String getCurrentFilename() {
        if (this.currentStream < this.inputStreams.length) {
            return this.inputStreams[this.currentStream].filename;
        }
        return null;
    }

    public static class DecoratedInputStream {
        private final String filename;
        private final InputStream inputStream;

        public DecoratedInputStream(String filename, InputStream inputStream) {
            this.filename = filename;
            this.inputStream = inputStream;
        }
    }
}

