/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import io.deephaven.io.streams.CurrentByteBufferSink;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SimpleByteBufferSink
implements CurrentByteBufferSink {
    private ByteBuffer currentBuffer;
    private final boolean direct;

    public SimpleByteBufferSink(ByteBuffer b, boolean direct) {
        this.currentBuffer = b;
        this.direct = direct;
    }

    public SimpleByteBufferSink(ByteBuffer b) {
        this(b, false);
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.currentBuffer;
    }

    @Override
    public ByteBuffer acceptBuffer(ByteBuffer b, int need) {
        if (b.remaining() < need) {
            b.flip();
            ByteBuffer b2 = this.direct ? ByteBuffer.allocateDirect(Math.max(b.capacity() * 2, b.remaining() + need)) : ByteBuffer.allocate(Math.max(b.capacity() * 2, b.remaining() + need));
            b2.put(b);
            this.currentBuffer = b = b2;
        }
        return b;
    }

    @Override
    public void close(ByteBuffer b) throws IOException {
    }
}

