/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log.impl;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.verify.Assert;
import io.deephaven.io.log.LogBufferPool;
import io.deephaven.io.streams.ByteBufferOutputStream;
import io.deephaven.io.streams.ByteBufferSink;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class LogOutputBaseImpl
implements LogOutput,
ByteBufferSink {
    @VisibleForTesting
    static final int START_SIZE_BYTES = 128;
    protected final ByteBufferOutputStream stream = new ByteBufferOutputStream(null, this);
    private int endOfHeaderPosition;
    private final LogBufferPool bufferPool;
    private ByteBuffer[] buffers;
    private int bufferCount;

    public LogOutputBaseImpl(LogBufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.bufferCount = 0;
        this.buffers = new ByteBuffer[2];
        this.endOfHeaderPosition = 0;
    }

    public LogOutput markEndOfHeader() {
        this.endOfHeaderPosition = this.stream.getBuffer().position();
        return this;
    }

    public int getEndOfHeaderOffset() {
        return this.endOfHeaderPosition;
    }

    private ByteBuffer nextBuffer(int need) {
        ByteBuffer byteBuffer = Objects.requireNonNull(this.bufferPool.take(need));
        this.buffers = (ByteBuffer[])ArrayUtil.put((Object[])this.buffers, (int)this.bufferCount, (Object)byteBuffer, ByteBuffer.class);
        ++this.bufferCount;
        this.stream.setBuffer(byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer acceptBuffer(ByteBuffer b, int need) {
        assert (b == this.buffers[this.bufferCount - 1]);
        return this.nextBuffer(need);
    }

    @Override
    public void close(ByteBuffer b) throws IOException {
        throw Assert.statementNeverExecuted();
    }

    public LogOutput start() {
        this.clear();
        this.nextBuffer(128);
        return this;
    }

    public LogOutput close() {
        return this;
    }

    public int relativeSize() {
        return this.size();
    }

    public int size() {
        int byteCount = 0;
        for (int i = 0; i < this.bufferCount; ++i) {
            byteCount += this.buffers[i].position();
        }
        return byteCount;
    }

    public int getBufferCount() {
        return this.bufferCount;
    }

    public ByteBuffer getBuffer(int i) {
        return this.buffers[i];
    }

    public LogOutput clear() {
        for (int i = 0; i < this.bufferCount; ++i) {
            this.bufferPool.give(this.buffers[i]);
            this.buffers[i] = null;
        }
        this.bufferCount = 0;
        this.stream.setBuffer(null);
        return this;
    }
}

