/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log.impl;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.text.TimestampBuffer;
import io.deephaven.base.text.TimestampBufferMicros;
import io.deephaven.io.log.LogBufferPool;
import io.deephaven.io.log.impl.LogOutputBaseImpl;
import io.deephaven.io.streams.ByteBufferSink;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;

public class LogOutputCsvImpl
extends LogOutputBaseImpl
implements LogOutput,
ByteBufferSink {
    protected final String lineSeparator = System.getProperty("line.separator");

    public LogOutputCsvImpl(LogBufferPool bufferPool) {
        super(bufferPool);
    }

    public LogOutput append(boolean b) {
        if (b) {
            return this.append("true");
        }
        return this.append("false");
    }

    public LogOutput append(char c) {
        try {
            this.stream.appendByte((byte)c);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(short s) {
        try {
            this.stream.appendShort(s);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(int i) {
        try {
            this.stream.appendInt(i);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(long l) {
        try {
            this.stream.appendLong(l);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput appendDouble(double f) {
        try {
            this.stream.appendDouble(f);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(LogOutputAppendable appendable) {
        return appendable == null ? this.append("null") : appendable.append((LogOutput)this);
    }

    public LogOutput append(LogOutput.LongFormatter formatter, long n) {
        formatter.format((LogOutput)this, n);
        return this;
    }

    public <T> LogOutput append(LogOutput.ObjFormatter<T> objFormatter, T t) {
        objFormatter.format((LogOutput)this, t);
        return this;
    }

    public <T> LogOutput append(LogOutput.ObjIntIntFormatter<T> objFormatter, T t, int nOffset, int nLength) {
        objFormatter.format((LogOutput)this, t, nOffset, nLength);
        return this;
    }

    public <T, U> LogOutput append(LogOutput.ObjObjFormatter<T, U> objObjFormatter, T t, U u) {
        objObjFormatter.format((LogOutput)this, t, u);
        return this;
    }

    public LogOutput append(CharSequence seq) {
        try {
            this.stream.appendBytes(seq == null ? "null" : seq);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(CharSequence seq, int start, int length) {
        try {
            if (seq == null) {
                this.stream.appendBytes("null");
            } else {
                this.stream.appendBytes(seq, start, length);
            }
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(ByteBuffer bb) {
        try {
            if (bb == null) {
                this.stream.appendBytes("null");
            } else {
                this.stream.appendByteBuffer(bb);
            }
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput appendTimestamp(long utcMillis, TimestampBuffer tb) {
        try {
            this.stream.write(tb.getTimestamp(utcMillis));
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput appendTimestampMicros(long utcMicros, TimestampBufferMicros tb) {
        try {
            this.stream.write(tb.getTimestamp(utcMicros));
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.append(sw.toString());
        return this;
    }

    public LogOutput append(byte[] ba) {
        try {
            this.stream.write(ba);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(byte[] ba, int pos, int length) {
        try {
            this.stream.write(ba, pos, length);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput append(byte[] ba, byte terminator) {
        try {
            for (int i = 0; i < ba.length && ba[i] != terminator; ++i) {
                this.stream.appendByte(ba[i]);
            }
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public LogOutput nf() {
        this.append(',');
        return this;
    }

    public LogOutput nl() {
        this.append(this.lineSeparator);
        return this;
    }
}

