/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogSink;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class InternalLoggerUtil {
    InternalLoggerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeEntryToStream(LogEntry entry, OutputStream outputStream, LogSink.Interceptor[] interceptors) throws IOException {
        for (int i = 0; i < entry.getBufferCount(); ++i) {
            ByteBuffer b = entry.getBuffer(i);
            b.flip();
        }
        if (interceptors != null) {
            for (LogSink.Interceptor interceptor : interceptors) {
                interceptor.element(entry, entry);
            }
        }
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            for (int i = 0; i < entry.getBufferCount(); ++i) {
                ByteBuffer b = entry.getBuffer(i);
                if (b.hasArray()) {
                    byte[] ba = b.array();
                    outputStream.write(ba, 0, b.limit());
                    continue;
                }
                int initialPosition = b.position();
                int initialLimit = b.limit();
                while (b.remaining() > 0) {
                    outputStream.write(b.get());
                }
                b.limit(initialLimit).position(initialPosition);
            }
        }
    }
}

