/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.io.log.LogLevel;
import io.deephaven.io.logger.LogBuffer;
import io.deephaven.io.logger.LogBufferRecord;
import io.deephaven.io.streams.SimpleByteBufferSink;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public class LogBufferOutputStream
extends OutputStream {
    private final LogBuffer sink;
    private final LogLevel level;
    private final int initialBufferSize;
    private final int maxBufferSize;
    private LogBufferRecord next;
    private SimpleByteBufferSink buffer;

    public LogBufferOutputStream(LogBuffer sink, LogLevel level, int initialBufferSize, int maxBufferSize) {
        this.sink = Objects.requireNonNull(sink);
        this.level = Objects.requireNonNull(level);
        this.initialBufferSize = initialBufferSize;
        this.maxBufferSize = maxBufferSize;
        this.primeNext(null);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.buffer.ensureSpace(1).put((byte)b);
        if ((byte)b == 10 || this.buffer.getBuffer().position() >= this.maxBufferSize) {
            this.record();
        }
    }

    private void record() {
        ByteBuffer out = this.buffer.getBuffer();
        out.flip();
        this.next.setLevel(this.level);
        this.next.setData(out);
        this.next.setTimestampMicros(System.currentTimeMillis() * 1000L);
        LogBufferRecord removed = this.sink.recordInternal(this.next);
        this.primeNext(removed);
    }

    private void primeNext(LogBufferRecord record) {
        if (record != null) {
            this.next = record;
            record.getData().clear();
            this.buffer = new SimpleByteBufferSink(record.getData());
        } else {
            this.next = new LogBufferRecord();
            this.buffer = new SimpleByteBufferSink(ByteBuffer.allocate(this.initialBufferSize));
        }
    }
}

