/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.logger.Logger;
import java.io.IOException;
import java.io.OutputStream;

public class LoggerOutputStream
extends OutputStream {
    private final Logger logger;
    private final LogLevel logLevel;
    private LogEntry currentEntry;
    private int currentSize;

    public LoggerOutputStream(Logger logger, LogLevel logLevel) {
        this.logger = logger;
        this.logLevel = logLevel;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        char c = (char)(b & 0xFF);
        if (this.currentEntry == null) {
            this.getNewEntry();
        }
        ++this.currentSize;
        if (this.currentSize >= 524288) {
            this.currentEntry.end();
            this.getNewEntry();
        }
        this.currentEntry = this.currentEntry.append(c);
        if (c == '\n') {
            this.currentEntry.end();
            this.currentEntry = null;
        }
    }

    private void getNewEntry() {
        this.currentEntry = this.logger.getEntry(this.logLevel);
        this.currentSize = 0;
    }
}

