/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.ClassUtil;
import io.deephaven.io.log.LogBufferPool;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogEntryPool;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.log.impl.LogEntryPoolImpl;
import io.deephaven.io.logger.LoggerImpl;
import io.deephaven.io.logger.LoggerTimeSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullLoggerImpl
extends LoggerImpl {
    private NullLoggerImpl(@NotNull LogEntryPool logEntryPool, @NotNull LogLevel loggingLevel, @NotNull LoggerTimeSource timeSource, TimeZone tz) {
        super(logEntryPool, new Sink(logEntryPool), null, loggingLevel, timeSource, tz, true, false);
    }

    public NullLoggerImpl(@NotNull LogLevel loggingLevel) {
        this(new LogEntryPoolImpl(1024, LogBufferPool.ofStrict(2048, 1024)), loggingLevel, new NullLoggerTimeSource(), null);
    }

    @Override
    public LogEntry getEntry(LogLevel level, long currentTimeMicros, @Nullable Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return EMPTY_LOG_ENTRY;
        }
        return ((LogEntry)this.logEntryPool.take()).start(this.logSink, level, currentTimeMicros, t);
    }

    private static class Sink
    implements LogSink<LogEntry> {
        private final LogEntryPool logEntryPool;
        private LogSink.Interceptor<LogEntry>[] interceptors = null;

        private Sink(@NotNull LogEntryPool logEntryPool) {
            this.logEntryPool = logEntryPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(@NotNull LogEntry entry) {
            try {
                for (int i = 0; i < entry.getBufferCount(); ++i) {
                    ByteBuffer b = entry.getBuffer(i);
                    b.flip();
                }
                if (this.interceptors != null) {
                    for (LogSink.Interceptor<LogEntry> interceptor : this.interceptors) {
                        try {
                            interceptor.element(entry, entry);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }
            }
            finally {
                entry.clear();
                this.logEntryPool.give(entry);
            }
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void terminate() {
        }

        @Override
        public void addInterceptor(@NotNull LogSink.Interceptor<LogEntry> logEntryInterceptor) {
            this.interceptors = (LogSink.Interceptor[])ArrayUtil.pushArray(logEntryInterceptor, (Object[])this.interceptors, (Class)ClassUtil.generify(LogSink.Interceptor.class));
        }
    }

    public static class NullLoggerTimeSource
    implements LoggerTimeSource {
        @Override
        public long currentTimeMicros() {
            return System.currentTimeMillis() * 1000L;
        }
    }
}

