/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.ClassUtil;
import io.deephaven.io.log.LogBufferPool;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogEntryPool;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.log.impl.LogEntryPoolImpl;
import io.deephaven.io.logger.InternalLoggerUtil;
import io.deephaven.io.logger.Logger;
import io.deephaven.io.logger.LoggerImpl;
import io.deephaven.io.logger.LoggerTimeSource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class ProcessStreamLoggerImpl
extends LoggerImpl {
    public static Logger makeLogger(@NotNull LoggerTimeSource timeSource, @NotNull TimeZone tz) {
        return ProcessStreamLoggerImpl.makeLogger(System.out, LogLevel.INFO, 1024, 2048, 1024, timeSource, tz);
    }

    public static Logger makeLogger(@NotNull OutputStream outputStream, @NotNull LogLevel loggingLevel, int bufferSize, int bufferCount, int entryCount, @NotNull LoggerTimeSource timeSource, @NotNull TimeZone tz) {
        LogEntryPoolImpl logEntryPool = new LogEntryPoolImpl(entryCount, LogBufferPool.ofStrict(bufferCount, bufferSize));
        return new ProcessStreamLoggerImpl(logEntryPool, outputStream, loggingLevel, timeSource, tz);
    }

    private ProcessStreamLoggerImpl(@NotNull LogEntryPool logEntryPool, @NotNull OutputStream outputStream, @NotNull LogLevel loggingLevel, @NotNull LoggerTimeSource timeSource, @NotNull TimeZone tz) {
        super(logEntryPool, new Sink(outputStream, logEntryPool), null, loggingLevel, timeSource, tz, true, false);
    }

    private static class Sink
    implements LogSink<LogEntry> {
        private final OutputStream outputStream;
        private final LogEntryPool logEntryPool;
        private LogSink.Interceptor<LogEntry>[] interceptors = null;

        private Sink(@NotNull OutputStream outputStream, @NotNull LogEntryPool logEntryPool) {
            this.outputStream = outputStream;
            this.logEntryPool = logEntryPool;
        }

        @Override
        public void write(@NotNull LogEntry e) {
            try {
                InternalLoggerUtil.writeEntryToStream(e, this.outputStream, this.interceptors);
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
            finally {
                e.clear();
                this.logEntryPool.give(e);
            }
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void terminate() {
        }

        @Override
        public void addInterceptor(@NotNull LogSink.Interceptor<LogEntry> logEntryInterceptor) {
            this.interceptors = (LogSink.Interceptor[])ArrayUtil.pushArray(logEntryInterceptor, (Object[])this.interceptors, (Class)ClassUtil.generify(LogSink.Interceptor.class));
        }
    }
}

