/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.ClassUtil;
import io.deephaven.base.pool.Pool;
import io.deephaven.base.pool.ThreadSafeLenientFixedSizePool;
import io.deephaven.io.log.LogBufferPool;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.log.impl.LogEntryImpl;
import io.deephaven.io.log.impl.LogOutputBaseImpl;
import io.deephaven.io.logger.InternalLoggerUtil;
import io.deephaven.io.logger.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public class StreamLoggerImpl
implements Logger {
    private static final LogBufferPool logBufferPool = LogBufferPool.of(2048, 512);
    private static final Pool<Entry> entries = new ThreadSafeLenientFixedSizePool(1024, () -> new Entry(logBufferPool), LogOutputBaseImpl::clear);
    private static final Sink SINK = new Sink();
    private final OutputStream stream;
    private LogLevel loggingLevel;

    public StreamLoggerImpl() {
        this(System.out, LogLevel.INFO);
    }

    public StreamLoggerImpl(OutputStream stream, LogLevel loggingLevel) {
        this.stream = stream;
        this.loggingLevel = loggingLevel;
    }

    private Entry startEntry(LogLevel level, long currentTime) {
        return ((Entry)entries.take()).start((LogSink)SINK, this.stream, level, currentTime);
    }

    private Entry startEntry(LogLevel level, long currentTime, Throwable t) {
        return ((Entry)entries.take()).start(SINK, this.stream, level, currentTime, t);
    }

    @Override
    public LogEntry getEntry(LogLevel level) {
        return this.isLevelEnabled(level) ? this.startEntry(level, System.currentTimeMillis() * 1000L) : LogEntry.NULL;
    }

    @Override
    public LogEntry getEntry(LogLevel level, Throwable t) {
        return this.isLevelEnabled(level) ? this.startEntry(level, System.currentTimeMillis() * 1000L, t) : LogEntry.NULL;
    }

    @Override
    public LogEntry getEntry(LogLevel level, long currentTime) {
        return this.isLevelEnabled(level) ? this.startEntry(level, currentTime) : LogEntry.NULL;
    }

    @Override
    public LogEntry getEntry(LogLevel level, long currentTime, Throwable t) {
        return this.isLevelEnabled(level) ? this.startEntry(level, currentTime, t) : LogEntry.NULL;
    }

    @Override
    public void setLevel(LogLevel level) {
        this.loggingLevel = level;
    }

    @Override
    public LogSink getSink() {
        return SINK;
    }

    @Override
    public boolean isLevelEnabled(LogLevel level) {
        return this.loggingLevel.getPriority() <= level.getPriority();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public LogEntry fatal() {
        return this.getEntry(LogLevel.FATAL);
    }

    @Override
    public LogEntry error() {
        return this.getEntry(LogLevel.ERROR);
    }

    @Override
    public LogEntry warn() {
        return this.getEntry(LogLevel.WARN);
    }

    @Override
    public LogEntry info() {
        return this.getEntry(LogLevel.INFO);
    }

    @Override
    public LogEntry debug() {
        return this.getEntry(LogLevel.DEBUG);
    }

    @Override
    public LogEntry trace() {
        return this.getEntry(LogLevel.TRACE);
    }

    @Override
    public LogEntry email() {
        return this.getEntry(LogLevel.EMAIL);
    }

    @Override
    public LogEntry fatal(Throwable t) {
        return this.getEntry(LogLevel.FATAL, t);
    }

    @Override
    public LogEntry error(Throwable t) {
        return this.getEntry(LogLevel.ERROR, t);
    }

    @Override
    public LogEntry warn(Throwable t) {
        return this.getEntry(LogLevel.WARN, t);
    }

    @Override
    public LogEntry info(Throwable t) {
        return this.getEntry(LogLevel.INFO, t);
    }

    @Override
    public LogEntry debug(Throwable t) {
        return this.getEntry(LogLevel.DEBUG, t);
    }

    @Override
    public LogEntry trace(Throwable t) {
        return this.getEntry(LogLevel.TRACE, t);
    }

    private void logObjectWithThrowable(LogLevel level, Object object, Throwable t) {
        LogEntry entry = this.getEntry(level, System.currentTimeMillis() * 1000L);
        if (object != null) {
            entry.append(object.toString());
        }
        if (t != null) {
            if (object != null) {
                entry.nl();
            }
            entry.append(t);
        }
        entry.endl();
    }

    @Override
    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            LogEntry e = this.fatal();
            e.append(object == null ? "" : object.toString());
            e.endl();
        }
    }

    @Override
    public void fatal(Object object, Throwable t) {
        if (this.isFatalEnabled()) {
            this.logObjectWithThrowable(LogLevel.FATAL, object, t);
        }
    }

    @Override
    public void error(Object object) {
        if (this.isErrorEnabled()) {
            LogEntry e = this.error();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void error(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.ERROR, object, t);
        }
    }

    @Override
    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            LogEntry e = this.warn();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void warn(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.WARN, object, t);
        }
    }

    @Override
    public void info(Object object) {
        if (this.isInfoEnabled()) {
            LogEntry e = this.info();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void info(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.INFO, object, t);
        }
    }

    @Override
    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            LogEntry e = this.debug();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void debug(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.DEBUG, object, t);
        }
    }

    @Override
    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            LogEntry e = this.trace();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void trace(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.TRACE, object, t);
        }
    }

    @Override
    public void email(Object object) {
        if (this.isEmailEnabled()) {
            LogEntry e = this.email();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void email(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.EMAIL, object, t);
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isLevelEnabled(LogLevel.FATAL);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(LogLevel.ERROR);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(LogLevel.WARN);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(LogLevel.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(LogLevel.DEBUG);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLevelEnabled(LogLevel.TRACE);
    }

    @Override
    public boolean isEmailEnabled() {
        return this.isLevelEnabled(LogLevel.EMAIL);
    }

    private static class Sink
    implements LogSink<Entry> {
        private LogSink.Interceptor<Entry>[] interceptors = null;

        private Sink() {
        }

        @Override
        public void write(Entry e) {
            try {
                InternalLoggerUtil.writeEntryToStream(e, e.stream, this.interceptors);
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
            finally {
                entries.give((Object)e);
            }
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void terminate() {
        }

        @Override
        public void addInterceptor(LogSink.Interceptor<Entry> entryInterceptor) {
            this.interceptors = (LogSink.Interceptor[])ArrayUtil.pushArray(entryInterceptor, (Object[])this.interceptors, (Class)ClassUtil.generify(LogSink.Interceptor.class));
        }
    }

    private static class Entry
    extends LogEntryImpl {
        private OutputStream stream;

        public Entry(LogBufferPool logBufferPool) {
            super(logBufferPool);
        }

        public Entry start(LogSink sink, OutputStream stream, LogLevel level, long currentTime) {
            return this.start(sink, stream, level, currentTime, null);
        }

        public Entry start(LogSink sink, OutputStream stream, LogLevel level, long currentTime, Throwable t) {
            super.start(sink, level, currentTime, t);
            this.stream = stream;
            return this;
        }
    }
}

