/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import io.deephaven.base.text.Convert;
import io.deephaven.io.streams.ByteBufferSink;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteBufferOutputStream
extends OutputStream
implements DataOutput {
    private ByteBuffer buf;
    private ByteBufferSink sink;

    public ByteBufferOutputStream(ByteBuffer b, ByteBufferSink sink) {
        this.buf = b;
        this.sink = Objects.requireNonNull(sink);
    }

    public void setBuffer(ByteBuffer b) {
        this.buf = b;
    }

    public void setSink(ByteBufferSink sink) {
        this.sink = Objects.requireNonNull(sink);
    }

    @Override
    public void close() throws IOException {
        ByteBuffer b = this.buf;
        this.buf = null;
        this.sink.close(b);
    }

    @Override
    public void flush() throws IOException {
        if (this.buf.position() != 0) {
            this.updateBuffer(0);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureRemaining(1);
        this.buf.put((byte)b);
    }

    @Override
    public void write(byte[] ba) throws IOException {
        this.write(ba, 0, ba.length);
    }

    @Override
    public void write(byte[] ba, int off, int len) throws IOException {
        int remaining;
        while ((remaining = this.buf.remaining()) < len) {
            this.buf.put(ba, off, remaining);
            this.updateBuffer(this.buf.capacity());
            len -= remaining;
            off += remaining;
        }
        this.buf.put(ba, off, len);
    }

    public void write(ByteBuffer b) throws IOException {
        int remaining;
        for (int len = b.remaining(); (remaining = this.buf.remaining()) < len; len -= remaining) {
            for (int i = 0; i < remaining; ++i) {
                this.buf.put(b.get());
            }
            this.updateBuffer(this.buf.capacity());
        }
        this.buf.put(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureRemaining(1);
        this.buf.put((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureRemaining(1);
        this.buf.put((byte)v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureRemaining(2);
        this.buf.putShort((short)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensureRemaining(2);
        this.buf.putChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureRemaining(4);
        this.buf.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureRemaining(8);
        this.buf.putLong(v);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.ensureRemaining(4);
        this.buf.putFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.ensureRemaining(8);
        this.buf.putDouble(d);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.appendBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.appendChars(s);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.writeUTF((CharSequence)str);
    }

    public void writeUTF(CharSequence str) throws IOException {
        int i;
        int remaining;
        int len = str.length();
        int total = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char c = str.charAt(i2);
            if (c <= '\u007f') {
                ++total;
                if (c != '\u0000') continue;
                ++total;
                continue;
            }
            if (c <= '\u07ff') {
                total += 2;
                continue;
            }
            total += 3;
        }
        if (total >= 65536) {
            throw new UTFDataFormatException();
        }
        int position = 0;
        this.ensureRemaining(2);
        this.buf.putShort((short)total);
        while ((remaining = this.buf.remaining() / 3) < len) {
            for (i = 0; i < remaining; ++i) {
                this.putUtf8(str.charAt(position++));
            }
            this.updateBuffer(Math.max(this.buf.capacity(), 3));
            len -= remaining;
        }
        for (i = 0; i < len; ++i) {
            this.putUtf8(str.charAt(position++));
        }
    }

    private void putUtf8(int c) {
        if (c <= 127) {
            if (c == 0) {
                this.buf.put((byte)-64);
                this.buf.put((byte)-128);
            } else {
                this.buf.put((byte)c);
            }
        } else if (c <= 2047) {
            this.buf.put((byte)(0xC0 | 0x1F & c >> 6));
            this.buf.put((byte)(0x80 | 0x3F & c));
        } else {
            this.buf.put((byte)(0xE0 | 0xF & c >> 12));
            this.buf.put((byte)(0x80 | 0x3F & c >> 6));
            this.buf.put((byte)(0x80 | 0x3F & c));
        }
    }

    public ByteBufferOutputStream appendByteBuffer(ByteBuffer bb) throws IOException {
        int remaining;
        int origPos = bb.position();
        int origLimit = bb.limit();
        while ((remaining = this.buf.remaining()) < bb.remaining()) {
            this.buf.put(bb.limit(bb.position() + remaining));
            bb.limit(origLimit);
            this.updateBuffer(this.buf.capacity());
        }
        this.buf.put(bb);
        bb.position(origPos);
        return this;
    }

    public ByteBufferOutputStream appendByte(byte n) throws IOException {
        this.ensureRemaining(1);
        this.buf.put(n);
        return this;
    }

    public ByteBufferOutputStream appendShort(short n) throws IOException {
        this.ensureRemaining(Convert.MAX_SHORT_BYTES);
        Convert.appendShort((short)n, (ByteBuffer)this.buf);
        return this;
    }

    public ByteBufferOutputStream appendInt(int n) throws IOException {
        this.ensureRemaining(Convert.MAX_INT_BYTES);
        Convert.appendInt((int)n, (ByteBuffer)this.buf);
        return this;
    }

    public ByteBufferOutputStream appendLong(long n) throws IOException {
        this.ensureRemaining(Convert.MAX_LONG_BYTES);
        Convert.appendLong((long)n, (ByteBuffer)this.buf);
        return this;
    }

    public ByteBufferOutputStream appendDouble(double p) throws IOException {
        this.ensureRemaining(Convert.MAX_DOUBLE_BYTES);
        Convert.appendDouble((double)p, (ByteBuffer)this.buf);
        return this;
    }

    public ByteBufferOutputStream appendChars(CharSequence s) throws IOException {
        return this.appendChars(s, 0, s.length());
    }

    public ByteBufferOutputStream appendChars(CharSequence s, int position, int len) throws IOException {
        int i;
        int remaining;
        while ((remaining = this.buf.remaining() / 2) < len) {
            for (i = 0; i < remaining; ++i) {
                this.buf.putChar(s.charAt(position++));
            }
            this.updateBuffer(Math.max(this.buf.capacity(), 2));
            len -= remaining;
        }
        for (i = 0; i < len; ++i) {
            this.buf.putChar(s.charAt(position++));
        }
        return this;
    }

    public ByteBufferOutputStream appendBytes(CharSequence s) throws IOException {
        return this.appendBytes(s, 0, s.length());
    }

    public ByteBufferOutputStream appendBytes(CharSequence s, int position, int len) throws IOException {
        int i;
        int remaining;
        while ((remaining = this.buf.remaining()) < len) {
            for (i = 0; i < remaining; ++i) {
                this.buf.put((byte)s.charAt(position++));
            }
            this.updateBuffer(this.buf.capacity());
            len -= remaining;
        }
        for (i = 0; i < len; ++i) {
            this.buf.put((byte)s.charAt(position++));
        }
        return this;
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    private void updateBuffer(int need) throws IOException {
        this.buf = Objects.requireNonNull(this.sink.acceptBuffer(this.buf, need));
    }

    private void ensureRemaining(int need) throws IOException {
        if (this.buf.remaining() < need) {
            this.updateBuffer(need);
        }
    }
}

