/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import io.deephaven.base.verify.Require;
import io.deephaven.io.streams.ByteBufferSink;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public interface CurrentByteBufferSink
extends ByteBufferSink {
    public ByteBuffer getBuffer();

    default public ByteBuffer ensureSpace(int need) throws IOException {
        ByteBuffer current = this.getBuffer();
        if (current.remaining() < need) {
            return this.acceptBuffer(current, need);
        }
        return current;
    }

    default public void flush() throws IOException {
        ByteBuffer current = this.getBuffer();
        if (current.position() != 0) {
            this.acceptBuffer(current, 0);
        }
    }

    default public void close() throws IOException {
        this.close(this.getBuffer());
    }

    public static class Adapter
    implements CurrentByteBufferSink {
        private final ByteBufferSink innerSink;
        private ByteBuffer current;

        public Adapter(@NotNull ByteBufferSink innerSink, @NotNull ByteBuffer initialBuffer) {
            this.innerSink = (ByteBufferSink)Require.neqNull((Object)innerSink, (String)"innerSink");
            this.current = (ByteBuffer)Require.neqNull((Object)initialBuffer, (String)"initialBuffer");
        }

        @Override
        public ByteBuffer getBuffer() {
            return this.current;
        }

        @Override
        public ByteBuffer acceptBuffer(@NotNull ByteBuffer buffer, int need) throws IOException {
            if (buffer != this.current) {
                throw new UnsupportedOperationException("Expected current buffer " + this.current + ", instead tried to accept " + buffer);
            }
            this.current = this.innerSink.acceptBuffer(this.current, need);
            return this.current;
        }

        @Override
        public void close(@NotNull ByteBuffer buffer) throws IOException {
            if (buffer != this.current) {
                throw new UnsupportedOperationException("Expected current buffer " + this.current + ", instead tried to close with " + buffer);
            }
            this.innerSink.close(this.current);
            this.current = null;
        }
    }
}

