/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import SevenZip.CRC;
import SevenZip.Compression.LZ.OutWindow;
import SevenZip.Compression.LZMA.Base;
import SevenZip.Compression.RangeCoder.BitTreeDecoder;
import io.deephaven.base.Reference;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.io.InputStreamFactory;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipException;

public class SevenZipInputStream
extends InputStream {
    public static final int UBYTE_TO_INT = 255;
    public static final long UBYTE_TO_LONG = 255L;
    public static final int USHORT_TO_INT = 65535;
    public static final long UINT_TO_LONG = 0xFFFFFFFFL;
    private static final byte[] SIGNATURE = new byte[]{55, 122, -68, -81, 39, 28};
    public static final long SIGNATURE_AS_LONG = (long)SIGNATURE[0] & 0xFFL | ((long)SIGNATURE[1] & 0xFFL) << 8 | ((long)SIGNATURE[2] & 0xFFL) << 16 | ((long)SIGNATURE[3] & 0xFFL) << 24 | ((long)SIGNATURE[4] & 0xFFL) << 32 | ((long)SIGNATURE[5] & 0xFFL) << 40;
    private static final int SIGNATURE_LENGTH = SIGNATURE.length;
    private static final byte ARCHIVE_VER_MAJOR = 0;
    private static final int NUM_MAX = Integer.MAX_VALUE;
    private static final int NUM_NO_INDEX = -1;
    public static final int START_HEADER_LENGTH = 20;
    public static final int START_HEADER_CRC_LENGTH = 4;
    private static final int VERSION_INFO_LENGTH = 2;
    private static final MethodID LZMA_METHOD_ID = new MethodID(3, 1, 1);
    private final InputStreamFactory m_inputStreamFactory;
    private boolean m_bIsClosed;
    private ArchiveIterator m_archiveIterator;
    private InputStream m_currentFolderStream;
    private LimitedInputStream m_currentFileStream;
    private byte[] m_singleByteBuf = new byte[1];

    private static ByteBuffer readToByteBuffer(InputStream inputStream, int nLength) throws IOException {
        byte[] bytes = new byte[nLength];
        int nOffset = 0;
        while (nLength > 0) {
            int nBytesRead = inputStream.read(bytes, nOffset, nLength);
            if (-1 == nBytesRead) {
                throw new EOFException();
            }
            nOffset += nBytesRead;
            nLength -= nBytesRead;
        }
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
    }

    private static void skipFully(InputStream inputStream, long nLength) throws IOException {
        while (nLength > 0L) {
            long nSkipped = inputStream.skip(nLength);
            if (nSkipped < 1L) {
                throw new EOFException();
            }
            nLength -= nSkipped;
        }
    }

    public SevenZipInputStream(InputStreamFactory inputStreamFactory) {
        Require.neqNull((Object)inputStreamFactory, (String)"inputStreamFactory");
        this.m_inputStreamFactory = inputStreamFactory;
    }

    public Entry getNextEntry(Behavior behavior) throws IOException {
        this.verifyIsOpen();
        try {
            FileItem fileItem;
            block17: {
                if (null == this.m_archiveIterator) {
                    ArchiveDatabaseEx archiveDatabaseEx = this.readArchiveDatabase();
                    this.m_archiveIterator = new ArchiveIterator(archiveDatabaseEx);
                }
                do {
                    if (!this.m_archiveIterator.m_fileItr.hasNext()) {
                        this.closeAllStreams();
                        return null;
                    }
                    fileItem = this.m_archiveIterator.m_fileItr.next();
                    if (fileItem.HasStream) break block17;
                } while (Behavior.SKIP_WHEN_NO_STREAM == behavior);
                if (null != this.m_currentFileStream) {
                    LimitedInputStream currentFileStream = this.m_currentFileStream;
                    this.m_currentFileStream = null;
                    currentFileStream.close();
                }
                return new Entry(fileItem);
            }
            if (0 == this.m_archiveIterator.m_nStreamsRemainingInFolder) {
                Folder folder;
                this.closeAllStreams();
                do {
                    if (!this.m_archiveIterator.m_folderItr.hasNext() || !this.m_archiveIterator.m_unpackStreamsForFolderItr.hasNext()) {
                        throw new ZipException("Bad header.");
                    }
                    folder = this.m_archiveIterator.m_folderItr.next();
                    this.m_archiveIterator.m_nStreamsRemainingInFolder = this.m_archiveIterator.m_unpackStreamsForFolderItr.next();
                } while (0 == this.m_archiveIterator.m_nStreamsRemainingInFolder);
                if (folder.Coders.isEmpty()) {
                    throw new ZipException("Bad header.");
                }
                if (folder.Coders.size() > 1) {
                    throw new ZipException("Unsupported compression type.");
                }
                CoderInfo coderInfo = folder.Coders.get(0);
                if (!coderInfo.isSimpleCoder()) {
                    throw new ZipException("Unsupported compression type.");
                }
                if (coderInfo.AltCoders.isEmpty()) {
                    throw new ZipException("Bad header.");
                }
                AltCoderInfo altCoderInfo = coderInfo.AltCoders.get(0);
                if (!LZMA_METHOD_ID.equals(altCoderInfo.MethodID)) {
                    throw new ZipException("Unsupported compression type.");
                }
                byte[] properties = altCoderInfo.Properties;
                long nUnpackedSize = folder.getUnpackSize();
                long nPackedSize = this.m_archiveIterator.m_packStreamSizesItr.next();
                long nOffsetIntoArchive = this.m_archiveIterator.m_nOffsetIntoArchive;
                this.m_archiveIterator.m_nOffsetIntoArchive += nPackedSize;
                this.m_currentFolderStream = new LzmaDecompressingInputStream(this.m_inputStreamFactory, nOffsetIntoArchive, nPackedSize, nUnpackedSize, properties);
            }
            if (null != this.m_currentFileStream) {
                this.m_currentFileStream.skipToEnd();
                this.m_currentFileStream.close();
                this.m_currentFileStream = null;
            }
            --this.m_archiveIterator.m_nStreamsRemainingInFolder;
            this.m_currentFileStream = new LimitedInputStream(this.m_currentFolderStream, fileItem.UnPackSize, LimitedInputStream.CloseUnderlyingOnClose.NO);
            return new Entry(fileItem);
        }
        catch (IOException e) {
            try {
                this.closeAllStreams();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchiveDatabaseEx readArchiveDatabase() throws IOException {
        ArchiveDatabaseEx archiveDatabaseEx = new ArchiveDatabaseEx();
        try (InputStream inputStream = this.m_inputStreamFactory.createInputStream();){
            byte[] signature = SevenZipInputStream.readToByteBuffer(inputStream, SIGNATURE_LENGTH).array();
            if (!Arrays.equals(signature, SIGNATURE)) {
                throw new ZipException("Bad file signature.");
            }
            new InArchive().readDatabase(inputStream, archiveDatabaseEx, this.m_inputStreamFactory, SIGNATURE_LENGTH);
        }
        archiveDatabaseEx.fill();
        return archiveDatabaseEx;
    }

    private void verifyIsOpen() throws IOException {
        if (this.m_bIsClosed) {
            throw new IOException("Stream closed.");
        }
    }

    @Override
    public int read() throws IOException {
        return -1 == this.read(this.m_singleByteBuf, 0, 1) ? -1 : this.m_singleByteBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int nOffset, int nLength) throws IOException {
        this.verifyIsOpen();
        if (nOffset < 0 || nLength < 0 || nOffset > bytes.length - nLength) {
            throw new IndexOutOfBoundsException();
        }
        if (0 == nLength) {
            return 0;
        }
        if (null == this.m_currentFileStream) {
            return -1;
        }
        return this.m_currentFileStream.read(bytes, nOffset, nLength);
    }

    @Override
    public void close() throws IOException {
        if (!this.m_bIsClosed) {
            this.m_bIsClosed = true;
            this.closeAllStreams();
        }
    }

    private void closeAllStreams() throws IOException {
        LimitedInputStream currentFileStream = this.m_currentFileStream;
        this.m_currentFileStream = null;
        InputStream currentFolderDecompressedStream = this.m_currentFolderStream;
        this.m_currentFolderStream = null;
        if (null != currentFileStream) {
            currentFileStream.close();
        }
        if (null != currentFolderDecompressedStream) {
            currentFolderDecompressedStream.close();
        }
    }

    public static enum Behavior {
        SKIP_WHEN_NO_STREAM,
        INCLUDE_WHEN_NO_STREAM;

    }

    public static class Entry {
        private final FileItem m_fileItem;

        protected Entry(FileItem fileItem) {
            this.m_fileItem = fileItem;
        }

        public String getName() {
            return this.m_fileItem.Name;
        }

        public boolean isDirectory() {
            return this.m_fileItem.IsDirectory;
        }
    }

    private static class ArchiveIterator {
        private Iterator<FileItem> m_fileItr;
        private Iterator<Folder> m_folderItr;
        private Iterator<Integer> m_unpackStreamsForFolderItr;
        private Iterator<Long> m_packStreamSizesItr;
        private long m_nOffsetIntoArchive;
        private int m_nStreamsRemainingInFolder;

        public ArchiveIterator(ArchiveDatabaseEx archiveDatabaseEx) {
            this.m_fileItr = archiveDatabaseEx.Files.iterator();
            this.m_folderItr = archiveDatabaseEx.Folders.iterator();
            this.m_unpackStreamsForFolderItr = archiveDatabaseEx.NumUnpackStreamsVector.iterator();
            this.m_packStreamSizesItr = archiveDatabaseEx.PackSizes.iterator();
            this.m_nOffsetIntoArchive = archiveDatabaseEx.ArchiveInfo.DataStartPosition + archiveDatabaseEx.ArchiveInfo.StartPositionAfterHeader;
        }
    }

    private static class LimitedInputStream
    extends InputStream {
        private InputStream m_inputStream;
        private long m_nBytesRemaining;
        private final CloseUnderlyingOnClose m_closeUnderlyingOnClose;

        public LimitedInputStream(InputStream inputStream, long nBytes) {
            this(inputStream, nBytes, CloseUnderlyingOnClose.YES);
        }

        public LimitedInputStream(InputStream inputStream, long nBytes, CloseUnderlyingOnClose closeUnderlyingOnClose) {
            this.m_inputStream = inputStream;
            this.m_nBytesRemaining = nBytes;
            this.m_closeUnderlyingOnClose = closeUnderlyingOnClose;
        }

        @Override
        public int read() throws IOException {
            if (null == this.m_inputStream) {
                throw new IOException("Stream closed.");
            }
            if (0L == this.m_nBytesRemaining) {
                return -1;
            }
            int nValue = this.m_inputStream.read();
            if (-1 != nValue) {
                --this.m_nBytesRemaining;
            }
            return nValue;
        }

        @Override
        public long skip(long nLength) throws IOException {
            if (null == this.m_inputStream) {
                throw new IOException("Stream closed.");
            }
            if (0L == this.m_nBytesRemaining) {
                return -1L;
            }
            long nSkipped = this.m_inputStream.skip(nLength = Math.min(nLength, this.m_nBytesRemaining));
            if (nSkipped > 0L) {
                this.m_nBytesRemaining -= nSkipped;
            }
            return nSkipped;
        }

        public void skipToEnd() throws IOException {
            SevenZipInputStream.skipFully(this, this.m_nBytesRemaining);
        }

        @Override
        public int read(byte[] bytes, int nOffset, int nLength) throws IOException {
            if (null == this.m_inputStream) {
                throw new IOException("Stream closed.");
            }
            if (nOffset < 0 || nLength < 0 || nOffset > bytes.length - nLength) {
                throw new IndexOutOfBoundsException();
            }
            if (0 == nLength) {
                return 0;
            }
            if (0L == this.m_nBytesRemaining) {
                return -1;
            }
            int nRead = this.m_inputStream.read(bytes, nOffset, nLength = (int)Math.min((long)nLength, this.m_nBytesRemaining));
            if (nRead > 0) {
                this.m_nBytesRemaining -= (long)nRead;
            }
            return nRead;
        }

        @Override
        public void close() throws IOException {
            if (null != this.m_inputStream) {
                InputStream inputStream = this.m_inputStream;
                this.m_inputStream = null;
                if (CloseUnderlyingOnClose.YES == this.m_closeUnderlyingOnClose) {
                    inputStream.close();
                }
            }
        }

        static enum CloseUnderlyingOnClose {
            YES,
            NO;

        }
    }

    private static class LzmaDecompressingInputStream
    extends InputStream {
        private InputStream m_inputStream;
        private LzmaIncrementalDecoder m_decoder;
        private ByteArrayOutputStream m_byteArrayOutputStream;
        private byte[] m_bytes;
        private int m_nBytesRemaining;
        private boolean m_bEof;
        private byte[] m_singleByteBuf = new byte[1];

        public LzmaDecompressingInputStream(InputStreamFactory inputStreamFactory, long nOffsetIntoArchive, long nPackedSize, long nUnpackedSize, byte[] properties) throws IOException {
            InputStream inputStream = inputStreamFactory.createInputStream();
            SevenZipInputStream.skipFully(inputStream, nOffsetIntoArchive);
            this.m_inputStream = new LimitedInputStream(inputStream, nPackedSize);
            this.m_byteArrayOutputStream = new ByteArrayOutputStream();
            this.m_decoder = new LzmaIncrementalDecoder(properties, this.m_inputStream, this.m_byteArrayOutputStream, nUnpackedSize);
        }

        @Override
        public int read() throws IOException {
            return -1 == this.read(this.m_singleByteBuf, 0, 1) ? -1 : this.m_singleByteBuf[0] & 0xFF;
        }

        @Override
        public void close() throws IOException {
            if (null != this.m_inputStream) {
                this.m_decoder = null;
                this.m_byteArrayOutputStream = null;
                this.m_bytes = null;
                InputStream inputStream = this.m_inputStream;
                this.m_inputStream = null;
                inputStream.close();
            }
        }

        @Override
        public int read(byte[] bytes, int nOffset, int nLength) throws IOException {
            if (null == this.m_inputStream) {
                throw new IOException("Stream closed.");
            }
            if (nOffset < 0 || nLength < 0 || nOffset > bytes.length - nLength) {
                throw new IndexOutOfBoundsException();
            }
            if (0 == nLength) {
                return 0;
            }
            while (true) {
                if (this.m_byteArrayOutputStream.size() > 0) {
                    this.m_bytes = this.m_byteArrayOutputStream.toByteArray();
                    this.m_byteArrayOutputStream.reset();
                    this.m_nBytesRemaining = this.m_bytes.length;
                }
                if (null != this.m_bytes) {
                    nLength = Math.min(nLength, this.m_nBytesRemaining);
                    System.arraycopy(this.m_bytes, this.m_bytes.length - this.m_nBytesRemaining, bytes, nOffset, nLength);
                    this.m_nBytesRemaining -= nLength;
                    if (0 == this.m_nBytesRemaining) {
                        this.m_bytes = null;
                    }
                    return nLength;
                }
                if (this.m_bEof) {
                    return -1;
                }
                this.m_bEof = this.m_decoder.Code();
            }
        }
    }

    private static class LzmaIncrementalDecoder {
        private int m_state;
        private int m_rep0;
        private int m_rep1;
        private int m_rep2;
        private int m_rep3;
        private long m_nowPos64;
        private byte m_prevByte;
        private long m_outSize;
        private boolean m_bEof;
        private OutWindow m_OutWindow = new OutWindow();
        private SevenZip.Compression.RangeCoder.Decoder m_RangeDecoder = new SevenZip.Compression.RangeCoder.Decoder();
        private short[] m_IsMatchDecoders = new short[192];
        private short[] m_IsRepDecoders = new short[12];
        private short[] m_IsRepG0Decoders = new short[12];
        private short[] m_IsRepG1Decoders = new short[12];
        private short[] m_IsRepG2Decoders = new short[12];
        private short[] m_IsRep0LongDecoders = new short[192];
        private BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
        private short[] m_PosDecoders = new short[114];
        private BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
        private LenDecoder m_LenDecoder = new LenDecoder();
        private LenDecoder m_RepLenDecoder = new LenDecoder();
        private LiteralDecoder m_LiteralDecoder = new LiteralDecoder();
        private int m_DictionarySize = -1;
        private int m_DictionarySizeCheck = -1;
        private int m_PosStateMask;

        public LzmaIncrementalDecoder(byte[] properties, InputStream inStream, OutputStream outStream, long outSize) throws IOException {
            for (int i = 0; i < 4; ++i) {
                this.m_PosSlotDecoder[i] = new BitTreeDecoder(6);
            }
            if (!this.SetDecoderProperties(properties)) {
                throw new ZipException("Invalid properties.");
            }
            this.Init(inStream, outStream);
            this.m_outSize = outSize;
        }

        private boolean SetDecoderProperties(byte[] properties) {
            if (properties.length < 5) {
                return false;
            }
            int val = properties[0] & 0xFF;
            int lc = val % 9;
            int remainder = val / 9;
            int lp = remainder % 5;
            int pb = remainder / 5;
            int dictionarySize = 0;
            for (int i = 0; i < 4; ++i) {
                dictionarySize += (properties[1 + i] & 0xFF) << i * 8;
            }
            if (!this.SetLcLpPb(lc, lp, pb)) {
                return false;
            }
            return this.SetDictionarySize(dictionarySize);
        }

        private boolean SetDictionarySize(int dictionarySize) {
            if (dictionarySize < 0) {
                return false;
            }
            if (this.m_DictionarySize != dictionarySize) {
                this.m_DictionarySize = dictionarySize;
                this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
                this.m_OutWindow.Create(Math.max(this.m_DictionarySizeCheck, 4096));
            }
            return true;
        }

        private boolean SetLcLpPb(int lc, int lp, int pb) {
            if (lc > 8 || lp > 4 || pb > 4) {
                return false;
            }
            this.m_LiteralDecoder.Create(lp, lc);
            int numPosStates = 1 << pb;
            this.m_LenDecoder.Create(numPosStates);
            this.m_RepLenDecoder.Create(numPosStates);
            this.m_PosStateMask = numPosStates - 1;
            return true;
        }

        private void Init(InputStream inStream, OutputStream outStream) throws IOException {
            this.m_RangeDecoder.SetStream(inStream);
            this.m_OutWindow.SetStream(outStream);
            this.m_OutWindow.Init(false);
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_IsMatchDecoders);
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_IsRep0LongDecoders);
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_IsRepDecoders);
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_IsRepG0Decoders);
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_IsRepG1Decoders);
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_IsRepG2Decoders);
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_PosDecoders);
            this.m_LiteralDecoder.Init();
            for (int i = 0; i < 4; ++i) {
                this.m_PosSlotDecoder[i].Init();
            }
            this.m_LenDecoder.Init();
            this.m_RepLenDecoder.Init();
            this.m_PosAlignDecoder.Init();
            this.m_RangeDecoder.Init();
            this.m_state = Base.StateInit();
            this.m_rep0 = 0;
            this.m_rep1 = 0;
            this.m_rep2 = 0;
            this.m_rep3 = 0;
            this.m_nowPos64 = 0L;
            this.m_prevByte = 0;
        }

        public boolean Code() throws IOException {
            if (this.m_bEof) {
                throw new EOFException();
            }
            if (this.m_outSize < 0L || this.m_nowPos64 < this.m_outSize) {
                int posState = (int)this.m_nowPos64 & this.m_PosStateMask;
                if (this.m_RangeDecoder.DecodeBit(this.m_IsMatchDecoders, (this.m_state << 4) + posState) == 0) {
                    LiteralDecoder.Decoder2 decoder2 = this.m_LiteralDecoder.GetDecoder((int)this.m_nowPos64, this.m_prevByte);
                    this.m_prevByte = !Base.StateIsCharState((int)this.m_state) ? decoder2.DecodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.GetByte(this.m_rep0)) : decoder2.DecodeNormal(this.m_RangeDecoder);
                    this.m_OutWindow.PutByte(this.m_prevByte);
                    this.m_state = Base.StateUpdateChar((int)this.m_state);
                    ++this.m_nowPos64;
                } else {
                    int len;
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRepDecoders, this.m_state) == 1) {
                        len = 0;
                        if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG0Decoders, this.m_state) == 0) {
                            if (this.m_RangeDecoder.DecodeBit(this.m_IsRep0LongDecoders, (this.m_state << 4) + posState) == 0) {
                                this.m_state = Base.StateUpdateShortRep((int)this.m_state);
                                len = 1;
                            }
                        } else {
                            int distance;
                            if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG1Decoders, this.m_state) == 0) {
                                distance = this.m_rep1;
                            } else {
                                if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG2Decoders, this.m_state) == 0) {
                                    distance = this.m_rep2;
                                } else {
                                    distance = this.m_rep3;
                                    this.m_rep3 = this.m_rep2;
                                }
                                this.m_rep2 = this.m_rep1;
                            }
                            this.m_rep1 = this.m_rep0;
                            this.m_rep0 = distance;
                        }
                        if (len == 0) {
                            len = this.m_RepLenDecoder.Decode(this.m_RangeDecoder, posState) + 2;
                            this.m_state = Base.StateUpdateRep((int)this.m_state);
                        }
                    } else {
                        this.m_rep3 = this.m_rep2;
                        this.m_rep2 = this.m_rep1;
                        this.m_rep1 = this.m_rep0;
                        len = 2 + this.m_LenDecoder.Decode(this.m_RangeDecoder, posState);
                        this.m_state = Base.StateUpdateMatch((int)this.m_state);
                        int posSlot = this.m_PosSlotDecoder[Base.GetLenToPosState((int)len)].Decode(this.m_RangeDecoder);
                        if (posSlot >= 4) {
                            int numDirectBits = (posSlot >> 1) - 1;
                            this.m_rep0 = (2 | posSlot & 1) << numDirectBits;
                            if (posSlot < 14) {
                                this.m_rep0 += BitTreeDecoder.ReverseDecode((short[])this.m_PosDecoders, (int)(this.m_rep0 - posSlot - 1), (SevenZip.Compression.RangeCoder.Decoder)this.m_RangeDecoder, (int)numDirectBits);
                            } else {
                                this.m_rep0 += this.m_RangeDecoder.DecodeDirectBits(numDirectBits - 4) << 4;
                                this.m_rep0 += this.m_PosAlignDecoder.ReverseDecode(this.m_RangeDecoder);
                                if (this.m_rep0 < 0) {
                                    if (this.m_rep0 == -1) {
                                        this.handleEof();
                                        return true;
                                    }
                                    throw new ZipException("Bad data.");
                                }
                            }
                        } else {
                            this.m_rep0 = posSlot;
                        }
                    }
                    if ((long)this.m_rep0 >= this.m_nowPos64 || this.m_rep0 >= this.m_DictionarySizeCheck) {
                        throw new ZipException("Bad data.");
                    }
                    this.m_OutWindow.CopyBlock(this.m_rep0, len);
                    this.m_nowPos64 += (long)len;
                    this.m_prevByte = this.m_OutWindow.GetByte(0);
                }
                return false;
            }
            this.handleEof();
            return true;
        }

        private void handleEof() throws IOException {
            this.m_bEof = true;
            this.m_OutWindow.Flush();
            this.m_OutWindow.ReleaseStream();
            this.m_RangeDecoder.ReleaseStream();
        }

        private static class LiteralDecoder {
            private Decoder2[] m_Coders;
            private int m_NumPrevBits;
            private int m_NumPosBits;
            private int m_PosMask;

            private LiteralDecoder() {
            }

            public void Create(int numPosBits, int numPrevBits) {
                if (this.m_Coders != null && this.m_NumPrevBits == numPrevBits && this.m_NumPosBits == numPosBits) {
                    return;
                }
                this.m_NumPosBits = numPosBits;
                this.m_PosMask = (1 << numPosBits) - 1;
                this.m_NumPrevBits = numPrevBits;
                int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
                this.m_Coders = new Decoder2[numStates];
                for (int i = 0; i < numStates; ++i) {
                    this.m_Coders[i] = new Decoder2();
                }
            }

            public void Init() {
                int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
                for (int i = 0; i < numStates; ++i) {
                    this.m_Coders[i].Init();
                }
            }

            Decoder2 GetDecoder(int pos, byte prevByte) {
                return this.m_Coders[((pos & this.m_PosMask) << this.m_NumPrevBits) + ((prevByte & 0xFF) >>> 8 - this.m_NumPrevBits)];
            }

            private static class Decoder2 {
                private short[] m_Decoders = new short[768];

                private Decoder2() {
                }

                public void Init() {
                    SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_Decoders);
                }

                public byte DecodeNormal(SevenZip.Compression.RangeCoder.Decoder rangeDecoder) throws IOException {
                    int symbol = 1;
                    while ((symbol = symbol << 1 | rangeDecoder.DecodeBit(this.m_Decoders, symbol)) < 256) {
                    }
                    return (byte)symbol;
                }

                public byte DecodeWithMatchByte(SevenZip.Compression.RangeCoder.Decoder rangeDecoder, byte matchByte) throws IOException {
                    int symbol = 1;
                    do {
                        int matchBit = matchByte >> 7 & 1;
                        matchByte = (byte)(matchByte << 1);
                        int bit = rangeDecoder.DecodeBit(this.m_Decoders, (1 + matchBit << 8) + symbol);
                        symbol = symbol << 1 | bit;
                        if (matchBit == bit) continue;
                        while (symbol < 256) {
                            symbol = symbol << 1 | rangeDecoder.DecodeBit(this.m_Decoders, symbol);
                        }
                        break;
                    } while (symbol < 256);
                    return (byte)symbol;
                }
            }
        }

        private static class LenDecoder {
            private short[] m_Choice = new short[2];
            private BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
            private BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
            private BitTreeDecoder m_HighCoder = new BitTreeDecoder(8);
            private int m_NumPosStates;

            private LenDecoder() {
            }

            public void Create(int numPosStates) {
                while (this.m_NumPosStates < numPosStates) {
                    this.m_LowCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                    this.m_MidCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                    ++this.m_NumPosStates;
                }
            }

            public void Init() {
                SevenZip.Compression.RangeCoder.Decoder.InitBitModels((short[])this.m_Choice);
                for (int posState = 0; posState < this.m_NumPosStates; ++posState) {
                    this.m_LowCoder[posState].Init();
                    this.m_MidCoder[posState].Init();
                }
                this.m_HighCoder.Init();
            }

            public int Decode(SevenZip.Compression.RangeCoder.Decoder rangeDecoder, int posState) throws IOException {
                if (rangeDecoder.DecodeBit(this.m_Choice, 0) == 0) {
                    return this.m_LowCoder[posState].Decode(rangeDecoder);
                }
                int symbol = 8;
                symbol = rangeDecoder.DecodeBit(this.m_Choice, 1) == 0 ? (symbol += this.m_MidCoder[posState].Decode(rangeDecoder)) : (symbol += 8 + this.m_HighCoder.Decode(rangeDecoder));
                return symbol;
            }
        }
    }

    private static class Handler {
        private ArchiveDatabaseEx m_database;
        private InputStreamFactory m_inputStreamFactory;

        private Handler() {
        }

        public void setDatabase(ArchiveDatabaseEx database) {
            this.m_database = database;
        }

        public void setInputStreamFactory(InputStreamFactory inputStreamFactory) {
            this.m_inputStreamFactory = inputStreamFactory;
        }

        public void Extract(int[] indices, int numItems, boolean testMode) throws IOException {
            boolean allFilesMode;
            boolean bl = allFilesMode = -1 == numItems;
            if (allFilesMode) {
                numItems = this.m_database.Files.size();
            }
            if (numItems == 0) {
                return;
            }
            LinkedList<ExtractFolderInfo> extractFolderInfoVector = new LinkedList<ExtractFolderInfo>();
            for (int i = 0; i < numItems; ++i) {
                int fileIndex = allFilesMode ? i : indices[i];
                int folderIndex = this.m_database.FileIndexToFolderIndexMap.get(fileIndex);
                if (-1 == folderIndex) {
                    extractFolderInfoVector.add(new ExtractFolderInfo(fileIndex, -1));
                    continue;
                }
                if (extractFolderInfoVector.isEmpty() || folderIndex != ((ExtractFolderInfo)extractFolderInfoVector.get((int)(extractFolderInfoVector.size() - 1))).FolderIndex) {
                    long unPackSize;
                    extractFolderInfoVector.add(new ExtractFolderInfo(-1, folderIndex));
                    Folder folderInfo = (Folder)this.m_database.Folders.get(folderIndex);
                    ((ExtractFolderInfo)extractFolderInfoVector.get((int)(extractFolderInfoVector.size() - 1))).UnPackSize = unPackSize = folderInfo.getUnpackSize();
                }
                ExtractFolderInfo efi = (ExtractFolderInfo)extractFolderInfoVector.get(extractFolderInfoVector.size() - 1);
                int startIndex = this.m_database.FolderStartFileIndex.get(folderIndex);
                for (int index = efi.ExtractStatuses.size(); index <= fileIndex - startIndex; ++index) {
                    efi.ExtractStatuses.add(index == fileIndex - startIndex);
                }
            }
            Decoder decoder = new Decoder();
            long currentImportantTotalUnPacked = 0L;
            int i = 0;
            while (i < extractFolderInfoVector.size()) {
                ExtractFolderInfo efi = (ExtractFolderInfo)extractFolderInfoVector.get(i);
                long totalFolderUnPacked = efi.UnPackSize;
                FolderOutStream folderOutStream = new FolderOutStream();
                ArchiveDatabaseEx database = this.m_database;
                int startIndex = efi.FileIndex != -1 ? efi.FileIndex : database.FolderStartFileIndex.get(efi.FolderIndex);
                folderOutStream.Init(database, 0, startIndex, efi.ExtractStatuses, testMode);
                if (efi.FileIndex == -1) {
                    int folderIndex = efi.FolderIndex;
                    Folder folderInfo = (Folder)database.Folders.get(folderIndex);
                    int packStreamIndex = database.FolderStartPackStreamIndex.get(folderIndex);
                    long folderStartPackPos = database.getFolderStreamPos(folderIndex, 0);
                    decoder.Decode(this.m_inputStreamFactory, folderStartPackPos, database.PackSizes.subList(packStreamIndex, database.PackSizes.size()), folderInfo, folderOutStream, null);
                }
                ++i;
                currentImportantTotalUnPacked += totalFolderUnPacked;
            }
        }
    }

    private static class FolderOutStream
    implements ISequentialOutStream {
        private FolderOutStream() {
        }

        public void Init(ArchiveDatabaseEx database, int nUnderlyingId, int startIndex, List<Boolean> extractStatuses, boolean testMode) {
        }
    }

    private static class ExtractFolderInfo {
        int FileIndex;
        int FolderIndex;
        List<Boolean> ExtractStatuses = new LinkedList<Boolean>();
        long UnPackSize;

        ExtractFolderInfo(int fileIndex, int folderIndex) {
            this.FileIndex = fileIndex;
            this.FolderIndex = folderIndex;
            this.UnPackSize = 0L;
            if (fileIndex != -1) {
                this.ExtractStatuses.add(true);
            }
        }
    }

    private static class Decoder {
        boolean _bindInfoExPrevIsDefinded;
        BindInfoEx _bindInfoExPrev;
        CoderMixer2 _mixerCoderCommon;
        ICompressCoder2 _mixerCoder;
        List<Object> _decoders = new LinkedList<Object>();

        private Decoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void Decode(InputStreamFactory inputStreamFactory, long startPos, List<Long> packSizes, Folder folderInfo, ISequentialOutStream outStream, ICompressProgressInfo compressProgress) throws IOException {
            LinkedList<SequentialInStreamWrapper> inStreams = new LinkedList<SequentialInStreamWrapper>();
            try {
                int i;
                boolean createNewCoders;
                for (int j = 0; j < folderInfo.PackStreams.size(); ++j) {
                    InputStream inputStream = inputStreamFactory.createInputStream();
                    SevenZipInputStream.skipFully(inputStream, startPos);
                    startPos += packSizes.get(j).longValue();
                    LimitedInputStream streamSpec = new LimitedInputStream(inputStream, packSizes.get(j));
                    inStreams.add(new SequentialInStreamWrapper(streamSpec));
                }
                int numCoders = folderInfo.Coders.size();
                BindInfoEx bindInfo = new BindInfoEx();
                Decoder.ConvertFolderItemInfoToBindInfo(folderInfo, bindInfo);
                if (!this._bindInfoExPrevIsDefinded) {
                    createNewCoders = true;
                } else {
                    boolean bl = createNewCoders = !Decoder.AreBindInfoExEqual(bindInfo, this._bindInfoExPrev);
                }
                if (createNewCoders) {
                    this._decoders.clear();
                    this._mixerCoder = null;
                    CoderMixer2 coderMixer2 = new CoderMixer2();
                    this._mixerCoder = coderMixer2;
                    this._mixerCoderCommon = coderMixer2;
                    this._mixerCoderCommon.SetBindInfo(bindInfo);
                    for (i = 0; i < numCoders; ++i) {
                        LzmaWrapper decoder;
                        CoderInfo coderInfo = folderInfo.Coders.get(i);
                        AltCoderInfo altCoderInfo = coderInfo.AltCoders.get(0);
                        if (coderInfo.isSimpleCoder()) {
                            decoder = null;
                            if (altCoderInfo.MethodID.equals(LZMA_METHOD_ID)) {
                                decoder = new LzmaWrapper();
                            }
                            if (null == decoder) {
                                throw new ZipException("Decoder not implemented.");
                            }
                        } else {
                            throw new ZipException("Decoder not implemented.");
                        }
                        this._decoders.add(decoder);
                        this._mixerCoderCommon.AddCoder(decoder);
                    }
                    this._bindInfoExPrev = bindInfo;
                    this._bindInfoExPrevIsDefinded = true;
                }
                this._mixerCoderCommon.ReInit();
                int packStreamIndex = 0;
                int unPackStreamIndex = 0;
                int coderIndex = 0;
                for (i = 0; i < numCoders; ++i) {
                    CoderInfo coderInfo = folderInfo.Coders.get(i);
                    AltCoderInfo altCoderInfo = coderInfo.AltCoders.get(0);
                    Object decoder = this._decoders.get(coderIndex);
                    if (decoder instanceof ICompressSetDecoderProperties2) {
                        ICompressSetDecoderProperties2 setDecoderProperties = (ICompressSetDecoderProperties2)decoder;
                        byte[] properties = altCoderInfo.Properties;
                        if (null != properties && properties.length > 0) {
                            setDecoderProperties.setDecoderProperties(properties);
                        }
                    }
                    ++coderIndex;
                    int numInStreams = coderInfo.NumInStreams;
                    int numOutStreams = coderInfo.NumOutStreams;
                    ArrayList<List<Long>> packSizesPointers = new ArrayList<List<Long>>(numInStreams);
                    ArrayList<List<Long>> unPackSizesPointers = new ArrayList<List<Long>>(numOutStreams);
                    int j = 0;
                    while (j < numOutStreams) {
                        unPackSizesPointers.add(folderInfo.UnpackSizes.subList(unPackStreamIndex, folderInfo.UnpackSizes.size()));
                        ++j;
                        ++unPackStreamIndex;
                    }
                    j = 0;
                    while (j < numInStreams) {
                        int bindPairIndex = folderInfo.findBindPairForInStream(packStreamIndex);
                        if (bindPairIndex >= 0) {
                            packSizesPointers.add(folderInfo.UnpackSizes.subList(folderInfo.BindPairs.get((int)bindPairIndex).OutIndex, folderInfo.UnpackSizes.size()));
                        } else {
                            int index = folderInfo.findPackStreamArrayIndex(packStreamIndex);
                            if (index < 0) {
                                throw new ZipException();
                            }
                            packSizesPointers.add(packSizes.subList(index, packSizes.size()));
                        }
                        ++j;
                        ++packStreamIndex;
                    }
                    this._mixerCoderCommon.SetCoderInfo(i, packSizesPointers, unPackSizesPointers);
                }
                if (numCoders == 0) {
                    return;
                }
                ArrayList<ISequentialInStream> inStreamPointers = new ArrayList<ISequentialInStream>(inStreams.size());
                for (i = 0; i < inStreams.size(); ++i) {
                    inStreamPointers.add((ISequentialInStream)inStreams.get(i));
                }
                List<ISequentialOutStream> list = Collections.singletonList(outStream);
                this._mixerCoder.Code(inStreamPointers, null, inStreams.size(), list, null, 1, compressProgress);
            }
            finally {
                for (ISequentialInStream iSequentialInStream : inStreams) {
                    ((InputStream)((Reference)iSequentialInStream).getValue()).close();
                }
            }
        }

        private static void ConvertFolderItemInfoToBindInfo(Folder folder, BindInfoEx bindInfo) {
            int i;
            for (i = 0; i < folder.BindPairs.size(); ++i) {
                BindPair bindPair = new BindPair();
                bindPair.InIndex = folder.BindPairs.get((int)i).InIndex;
                bindPair.OutIndex = folder.BindPairs.get((int)i).OutIndex;
                bindInfo.BindPairs.add(bindPair);
            }
            int outStreamIndex = 0;
            for (i = 0; i < folder.Coders.size(); ++i) {
                CoderStreamsInfo coderStreamsInfo = new CoderStreamsInfo();
                CoderInfo coderInfo = folder.Coders.get(i);
                coderStreamsInfo.NumInStreams = coderInfo.NumInStreams;
                coderStreamsInfo.NumOutStreams = coderInfo.NumOutStreams;
                bindInfo.Coders.add(coderStreamsInfo);
                AltCoderInfo altCoderInfo = coderInfo.AltCoders.get(0);
                bindInfo.CoderMethodIDs.add(altCoderInfo.MethodID);
                int j = 0;
                while (j < coderStreamsInfo.NumOutStreams) {
                    if (folder.findBindPairForOutStream(outStreamIndex) < 0) {
                        bindInfo.OutStreams.add(outStreamIndex);
                    }
                    ++j;
                    ++outStreamIndex;
                }
            }
            for (i = 0; i < folder.PackStreams.size(); ++i) {
                bindInfo.InStreams.add(Integer.valueOf(folder.PackStreams.get(i)));
            }
        }

        private static boolean AreCodersEqual(CoderStreamsInfo a1, CoderStreamsInfo a2) {
            return a1.NumInStreams == a2.NumInStreams && a1.NumOutStreams == a2.NumOutStreams;
        }

        static boolean AreBindPairsEqual(BindPair a1, BindPair a2) {
            return a1.InIndex == a2.InIndex && a1.OutIndex == a2.OutIndex;
        }

        static boolean AreBindInfoExEqual(BindInfoEx a1, BindInfoEx a2) {
            int i;
            if (a1.Coders.size() != a2.Coders.size()) {
                return false;
            }
            for (i = 0; i < a1.Coders.size(); ++i) {
                if (Decoder.AreCodersEqual((CoderStreamsInfo)a1.Coders.get(i), (CoderStreamsInfo)a2.Coders.get(i))) continue;
                return false;
            }
            if (a1.BindPairs.size() != a2.BindPairs.size()) {
                return false;
            }
            for (i = 0; i < a1.BindPairs.size(); ++i) {
                if (Decoder.AreBindPairsEqual((BindPair)a1.BindPairs.get(i), (BindPair)a2.BindPairs.get(i))) continue;
                return false;
            }
            for (i = 0; i < a1.CoderMethodIDs.size(); ++i) {
                if (a1.CoderMethodIDs.get(i) == a2.CoderMethodIDs.get(i)) continue;
                return false;
            }
            if (a1.InStreams.size() != a2.InStreams.size()) {
                return false;
            }
            return a1.OutStreams.size() == a2.OutStreams.size();
        }
    }

    private static class BindInfoEx
    extends BindInfo {
        List<MethodID> CoderMethodIDs = new LinkedList<MethodID>();

        private BindInfoEx() {
        }
    }

    private static class BindInfo {
        List<CoderStreamsInfo> Coders = new LinkedList<CoderStreamsInfo>();
        List<BindPair> BindPairs = new LinkedList<BindPair>();
        List<Integer> InStreams = new LinkedList<Integer>();
        List<Integer> OutStreams = new LinkedList<Integer>();

        private BindInfo() {
        }

        void getNumStreams(Reference<Integer> numInStreamsRef, Reference<Integer> numOutStreamsRef) {
            int numInStreams = 0;
            int numOutStreams = 0;
            for (CoderStreamsInfo coderStreamsInfo : this.Coders) {
                numInStreams += coderStreamsInfo.NumInStreams;
                numOutStreams += coderStreamsInfo.NumOutStreams;
            }
            numInStreamsRef.setValue((Object)numInStreams);
            numOutStreamsRef.setValue((Object)numOutStreams);
        }

        int findBinderForInStream(int inStream) {
            for (int i = 0; i < this.BindPairs.size(); ++i) {
                if (this.BindPairs.get((int)i).InIndex != inStream) continue;
                return i;
            }
            return -1;
        }

        int findBinderForOutStream(int outStream) {
            for (int i = 0; i < this.BindPairs.size(); ++i) {
                if (this.BindPairs.get((int)i).OutIndex != outStream) continue;
                return i;
            }
            return -1;
        }

        int getCoderInStreamIndex(int coderIndex) {
            int streamIndex = 0;
            for (int i = 0; i < coderIndex; ++i) {
                streamIndex += this.Coders.get((int)i).NumInStreams;
            }
            return streamIndex;
        }

        int getCoderOutStreamIndex(int coderIndex) {
            int streamIndex = 0;
            for (int i = 0; i < coderIndex; ++i) {
                streamIndex += this.Coders.get((int)i).NumOutStreams;
            }
            return streamIndex;
        }

        void findInStream(int streamIndex, Reference<Integer> coderIndexRef, Reference<Integer> coderStreamIndexRef) throws ZipException {
            for (int coderIndex = 0; coderIndex < this.Coders.size(); ++coderIndex) {
                int curSize = this.Coders.get((int)coderIndex).NumInStreams;
                if (streamIndex < curSize) {
                    int coderStreamIndex = streamIndex;
                    coderStreamIndexRef.setValue((Object)coderStreamIndex);
                    coderIndexRef.setValue((Object)coderIndex);
                    return;
                }
                streamIndex -= curSize;
            }
            throw new ZipException();
        }

        void findOutStream(int streamIndex, Reference<Integer> coderIndexRef, Reference<Integer> coderStreamIndexRef) throws ZipException {
            for (int coderIndex = 0; coderIndex < this.Coders.size(); ++coderIndex) {
                int curSize = this.Coders.get((int)coderIndex).NumOutStreams;
                if (streamIndex < curSize) {
                    int coderStreamIndex = streamIndex;
                    coderStreamIndexRef.setValue((Object)coderStreamIndex);
                    coderIndexRef.setValue((Object)coderIndex);
                    return;
                }
                streamIndex -= curSize;
            }
            throw new ZipException();
        }
    }

    private static class CoderStreamsInfo {
        int NumInStreams;
        int NumOutStreams;

        private CoderStreamsInfo() {
        }
    }

    private static interface ICompressCoder2
    extends ICompressCoder {
        public void Code(List<ISequentialInStream> var1, List<List<Long>> var2, int var3, List<ISequentialOutStream> var4, List<List<Long>> var5, int var6, ICompressProgressInfo var7) throws IOException;
    }

    private static interface ICompressCoder {
        public void Code(ISequentialInStream var1, ISequentialOutStream var2, long var3, long var5, ICompressProgressInfo var7) throws IOException;
    }

    private static interface ICompressProgressInfo {
        public void SetRatioInfo(long var1, long var3);
    }

    private static interface ICompressSetDecoderProperties2 {
        public void setDecoderProperties(byte[] var1) throws ZipException;
    }

    private static class LzmaWrapper
    implements ICompressCoder,
    ICompressSetDecoderProperties2 {
        private final SevenZip.Compression.LZMA.Decoder decoder = new SevenZip.Compression.LZMA.Decoder();

        private LzmaWrapper() {
        }

        @Override
        public void setDecoderProperties(byte[] properties) throws ZipException {
            if (!this.decoder.SetDecoderProperties(properties)) {
                throw new ZipException("Bad decoder properties.");
            }
        }

        @Override
        public void Code(ISequentialInStream inStream, ISequentialOutStream outStream, long inSize, long outSize, ICompressProgressInfo progress) throws IOException {
            if (!this.decoder.Code((InputStream)((Reference)inStream).getValue(), (OutputStream)((Reference)outStream).getValue(), outSize)) {
                throw new ZipException("Bad compressed data.");
            }
        }
    }

    private static class CoderMixer2
    implements ICompressCoder2 {
        private BindInfoEx m_bindInfo;
        private List<ICompressCoder> m_compressCoders = new LinkedList<ICompressCoder>();
        private List<Long> m_packSizes = new LinkedList<Long>();
        private List<Long> m_unpackSizes = new LinkedList<Long>();

        private CoderMixer2() {
        }

        public void SetBindInfo(BindInfoEx bindInfo) {
            this.m_bindInfo = bindInfo;
            for (CoderStreamsInfo coderStreamsInfo : this.m_bindInfo.Coders) {
                if (1 == coderStreamsInfo.NumInStreams && 1 == coderStreamsInfo.NumOutStreams) continue;
                Assert.statementNeverExecuted((String)"Not implemented.");
            }
        }

        public void ReInit() {
            this.m_packSizes.clear();
            this.m_unpackSizes.clear();
        }

        public void AddCoder(ICompressCoder decoder) {
            this.m_compressCoders.add(decoder);
        }

        public void SetCoderInfo(int nCoderIndex, List<List<Long>> packSizes, List<List<Long>> unpackSizes) {
            Assert.eq((int)nCoderIndex, (String)"nCoderIndex", (int)this.m_packSizes.size(), (String)"m_packSizes.size()");
            Assert.eq((int)packSizes.size(), (String)"packSizes.size()", (int)1);
            Assert.eq((int)unpackSizes.size(), (String)"unpackSizes.size()", (int)1);
            List<Long> packSizesInner = packSizes.get(0);
            List<Long> unpackSizesInner = unpackSizes.get(0);
            Assert.geq((int)packSizesInner.size(), (String)"packSizesInner.size()", (int)1);
            Assert.geq((int)unpackSizesInner.size(), (String)"unpackSizesInner.size()", (int)1);
            this.m_packSizes.add(packSizesInner.get(0));
            this.m_unpackSizes.add(unpackSizesInner.get(0));
        }

        @Override
        public void Code(ISequentialInStream inStream, ISequentialOutStream outStream, long inSize, long outSize, ICompressProgressInfo progress) {
            Assert.statementNeverExecuted();
        }

        @Override
        public void Code(List<ISequentialInStream> inStreams, List<List<Long>> inSizes, int nInStreams, List<ISequentialOutStream> outStreams, List<List<Long>> outSizes, int nOutStreams, ICompressProgressInfo progress) throws IOException {
            Assert.eq((int)inStreams.size(), (String)"inStreams.size()", (int)nInStreams, (String)"nInStreams");
            Assert.eq((int)outStreams.size(), (String)"outStreams.size()", (int)nOutStreams, (String)"nOutStreams");
            Assert.eq((int)nOutStreams, (String)"nOutStreams", (int)this.m_compressCoders.size(), (String)"m_compressCoders.size()");
            Assert.eq((int)nOutStreams, (String)"nOutStreams", (int)nInStreams, (String)"nInStreams");
            Assert.eq((int)this.m_compressCoders.size(), (String)"m_compressCoders.size()", (int)this.m_packSizes.size(), (String)"m_packSizes.size()");
            Iterator<ICompressCoder> compressCodersItr = this.m_compressCoders.iterator();
            Iterator<ISequentialInStream> inStreamsItr = inStreams.iterator();
            Iterator<ISequentialOutStream> outStreamsItr = outStreams.iterator();
            Iterator<Long> packSizesItr = this.m_packSizes.iterator();
            Iterator<Long> unpackSizesItr = this.m_unpackSizes.iterator();
            while (compressCodersItr.hasNext()) {
                compressCodersItr.next().Code(inStreamsItr.next(), outStreamsItr.next(), packSizesItr.next(), unpackSizesItr.next(), progress);
            }
        }
    }

    private static class SequentialInStreamWrapper
    extends Reference<InputStream>
    implements ISequentialInStream {
        public SequentialInStreamWrapper(InputStream value) {
            super((Object)value);
        }
    }

    private static interface ISequentialInStream {
    }

    private static class SequentialOutStreamWrapper
    extends Reference<OutputStream>
    implements ISequentialOutStream {
        public SequentialOutStreamWrapper(OutputStream value) {
            super((Object)value);
        }
    }

    private static interface ISequentialOutStream {
    }

    private static class InArchive {
        private InArchive() {
        }

        public void readDatabase(InputStream inputStream, ArchiveDatabaseEx database, InputStreamFactory inputStreamFactory, int nBeginStreamPosition) throws IOException {
            long type;
            database.clear();
            database.ArchiveInfo.StartPosition = nBeginStreamPosition;
            ByteBuffer byteBuffer = SevenZipInputStream.readToByteBuffer(inputStream, 2);
            database.ArchiveInfo.Version.Major = byteBuffer.get();
            database.ArchiveInfo.Version.Minor = byteBuffer.get();
            if (0 != database.ArchiveInfo.Version.Major) {
                throw new ZipException("Archive version mismatch.");
            }
            byteBuffer = SevenZipInputStream.readToByteBuffer(inputStream, 4);
            int nStartHeaderCrc = byteBuffer.getInt();
            byteBuffer = SevenZipInputStream.readToByteBuffer(inputStream, 20);
            CRC crc = new CRC();
            crc.Update(byteBuffer.array());
            long nNextHeaderOffset = byteBuffer.getLong();
            long nNextHeaderSize = byteBuffer.getLong();
            int nNextHeaderCrc = byteBuffer.getInt();
            database.ArchiveInfo.StartPositionAfterHeader = database.ArchiveInfo.StartPosition + 2L + 4L + 20L;
            if (nStartHeaderCrc != crc.GetDigest()) {
                throw new ZipException("Header CRC mismatch.");
            }
            if (0L == nNextHeaderSize) {
                return;
            }
            if (nNextHeaderSize > Integer.MAX_VALUE) {
                throw new ZipException("Invalid header size.");
            }
            SevenZipInputStream.skipFully(inputStream, nNextHeaderOffset);
            byteBuffer = SevenZipInputStream.readToByteBuffer(inputStream, (int)nNextHeaderSize);
            crc.Init();
            crc.Update(byteBuffer.array());
            if (nNextHeaderCrc != crc.GetDigest()) {
                throw new ZipException("Header CRC mismatch.");
            }
            LinkedList<ByteBuffer> dataVector = new LinkedList<ByteBuffer>();
            while ((type = this.readId(byteBuffer)) != 1L) {
                if (type != 23L) {
                    throw new ZipException("Bad block type in header.");
                }
                Reference startPositionAfterHeaderRef = new Reference((Object)database.ArchiveInfo.StartPositionAfterHeader);
                Reference dataStartPosition2Ref = new Reference((Object)database.ArchiveInfo.DataStartPosition2);
                this.readAndDecodePackedStreams(byteBuffer, (Reference<Long>)startPositionAfterHeaderRef, (Reference<Long>)dataStartPosition2Ref, dataVector, inputStreamFactory);
                database.ArchiveInfo.StartPositionAfterHeader = (Long)startPositionAfterHeaderRef.getValue();
                database.ArchiveInfo.DataStartPosition2 = (Long)dataStartPosition2Ref.getValue();
                if (dataVector.isEmpty()) {
                    return;
                }
                if (dataVector.size() > 1) {
                    throw new ZipException("Bad header.");
                }
                byteBuffer = (ByteBuffer)dataVector.remove(0);
            }
            this.readHeader(byteBuffer, database, inputStreamFactory);
        }

        private void readHeader(ByteBuffer byteBuffer, ArchiveDatabaseEx database, InputStreamFactory inputStreamFactory) throws IOException {
            long type;
            int i;
            long nBlockType = this.readId(byteBuffer);
            if (2L == nBlockType) {
                this.readArchiveProperties(byteBuffer, database.ArchiveInfo);
                nBlockType = this.readId(byteBuffer);
            }
            ArrayList<ByteBuffer> dataVector = new ArrayList<ByteBuffer>();
            if (3L == nBlockType) {
                Reference startPositionAfterHeaderRef = new Reference((Object)database.ArchiveInfo.StartPositionAfterHeader);
                Reference dataStartPosition2Ref = new Reference((Object)database.ArchiveInfo.DataStartPosition2);
                this.readAndDecodePackedStreams(byteBuffer, (Reference<Long>)startPositionAfterHeaderRef, (Reference<Long>)dataStartPosition2Ref, dataVector, inputStreamFactory);
                database.ArchiveInfo.StartPositionAfterHeader = (Long)startPositionAfterHeaderRef.getValue();
                database.ArchiveInfo.DataStartPosition2 = (Long)dataStartPosition2Ref.getValue();
                database.ArchiveInfo.DataStartPosition2 += database.ArchiveInfo.StartPositionAfterHeader;
                nBlockType = this.readId(byteBuffer);
            }
            LinkedList<Long> unPackSizes = new LinkedList<Long>();
            LinkedList<Integer> digests = new LinkedList<Integer>();
            if (4L == nBlockType) {
                Reference dataStartPositionRef = new Reference((Object)database.ArchiveInfo.DataStartPosition);
                this.readStreamsInfo(byteBuffer, dataVector, (Reference<Long>)dataStartPositionRef, database.PackSizes, database.PackCRCs, database.Folders, database.NumUnpackStreamsVector, unPackSizes, digests);
                database.ArchiveInfo.DataStartPosition = (Long)dataStartPositionRef.getValue();
                nBlockType = this.readId(byteBuffer);
            } else {
                for (Folder folder : database.Folders) {
                    database.NumUnpackStreamsVector.add(1);
                    unPackSizes.add(folder.getUnpackSize());
                    digests.add(folder.UnpackCRC);
                }
            }
            database.Files.clear();
            if (nBlockType == 0L) {
                return;
            }
            if (nBlockType != 5L) {
                throw new ZipException("Bad block type in header.");
            }
            int numFiles = this.readNum(byteBuffer);
            for (i = 0; i < numFiles; ++i) {
                database.Files.add(new FileItem());
            }
            database.ArchiveInfo.FileInfoPopIDs.add(9L);
            if (!database.PackSizes.isEmpty()) {
                database.ArchiveInfo.FileInfoPopIDs.add(6L);
            }
            if (numFiles > 0 && !digests.isEmpty()) {
                database.ArchiveInfo.FileInfoPopIDs.add(10L);
            }
            ArrayList<Boolean> emptyStreamVector = new ArrayList<Boolean>(numFiles);
            for (i = 0; i < numFiles; ++i) {
                emptyStreamVector.add(false);
            }
            LinkedList<Boolean> emptyFileVector = new LinkedList<Boolean>();
            LinkedList<Boolean> antiFileVector = new LinkedList<Boolean>();
            int numEmptyStreams = 0;
            block12: while ((type = this.readId(byteBuffer)) != 0L) {
                long size = this.readNumber(byteBuffer);
                database.ArchiveInfo.FileInfoPopIDs.add(type);
                switch ((int)type) {
                    case 17: {
                        ByteBuffer workingByteBuffer = this.chooseStream(byteBuffer, dataVector);
                        this.readFileNames(workingByteBuffer, database.Files);
                        continue block12;
                    }
                    case 21: {
                        FileItem file;
                        ArrayList<Boolean> boolVector = new ArrayList<Boolean>(database.Files.size());
                        this.readBoolVector2(byteBuffer, database.Files.size(), boolVector);
                        ByteBuffer workingByteBuffer = this.chooseStream(byteBuffer, dataVector);
                        for (i = 0; i < numFiles; ++i) {
                            file = (FileItem)database.Files.get(i);
                            file.AreAttributesDefined = (Boolean)boolVector.get(i);
                            if (!file.AreAttributesDefined) continue;
                            file.Attributes = workingByteBuffer.getInt();
                        }
                        continue block12;
                    }
                    case 24: {
                        FileItem file;
                        ArrayList<Boolean> boolVector = new ArrayList(database.Files.size());
                        this.readBoolVector2(byteBuffer, database.Files.size(), boolVector);
                        ByteBuffer workingByteBuffer = this.chooseStream(byteBuffer, dataVector);
                        for (i = 0; i < numFiles; ++i) {
                            file = (FileItem)database.Files.get(i);
                            file.IsStartPosDefined = (Boolean)boolVector.get(i);
                            if (!file.IsStartPosDefined) continue;
                            file.StartPos = workingByteBuffer.getLong();
                        }
                        continue block12;
                    }
                    case 14: {
                        this.readBoolVector(byteBuffer, numFiles, emptyStreamVector);
                        for (i = 0; i < emptyStreamVector.size(); ++i) {
                            if (!((Boolean)emptyStreamVector.get(i)).booleanValue()) continue;
                            ++numEmptyStreams;
                        }
                        for (i = 0; i < numEmptyStreams; ++i) {
                            emptyFileVector.add(false);
                            antiFileVector.add(false);
                        }
                        continue block12;
                    }
                    case 15: {
                        this.readBoolVector(byteBuffer, numEmptyStreams, emptyFileVector);
                        continue block12;
                    }
                    case 16: {
                        this.readBoolVector(byteBuffer, numEmptyStreams, antiFileVector);
                        continue block12;
                    }
                    case 18: 
                    case 19: 
                    case 20: {
                        this.readTime(byteBuffer, dataVector, database.Files, type);
                        continue block12;
                    }
                }
                database.ArchiveInfo.FileInfoPopIDs.remove(database.ArchiveInfo.FileInfoPopIDs.size() - 1);
                this.skipData(byteBuffer, size);
            }
            int emptyFileIndex = 0;
            int sizeIndex = 0;
            for (i = 0; i < numFiles; ++i) {
                FileItem file = (FileItem)database.Files.get(i);
                boolean bl = file.HasStream = (Boolean)emptyStreamVector.get(i) == false;
                if (file.HasStream) {
                    file.IsDirectory = false;
                    file.IsAnti = false;
                    file.UnPackSize = (Long)unPackSizes.get(sizeIndex);
                    file.FileCRC = (Integer)digests.get(sizeIndex);
                    ++sizeIndex;
                    continue;
                }
                file.IsDirectory = (Boolean)emptyFileVector.get(emptyFileIndex) == false;
                file.IsAnti = (Boolean)antiFileVector.get(emptyFileIndex);
                ++emptyFileIndex;
                file.UnPackSize = 0L;
                file.FileCRC = null;
            }
        }

        private void readTime(ByteBuffer byteBuffer, List<ByteBuffer> alternateByteBuffers, List<FileItem> files, long type) throws ZipException {
            ArrayList<Boolean> boolVector = new ArrayList<Boolean>(files.size());
            this.readBoolVector2(byteBuffer, files.size(), boolVector);
            byteBuffer = this.chooseStream(byteBuffer, alternateByteBuffers);
            block5: for (int i = 0; i < files.size(); ++i) {
                FileItem file = files.get(i);
                long fileTime = 0L;
                boolean defined = (Boolean)boolVector.get(i);
                if (defined) {
                    fileTime = byteBuffer.getLong();
                }
                switch ((int)type) {
                    case 18: {
                        file.IsCreationTimeDefined = defined;
                        if (!defined) continue block5;
                        file.CreationTime = fileTime;
                        continue block5;
                    }
                    case 20: {
                        file.IsLastWriteTimeDefined = defined;
                        if (!defined) continue block5;
                        file.LastWriteTime = fileTime;
                        continue block5;
                    }
                    case 19: {
                        file.IsLastAccessTimeDefined = defined;
                        if (!defined) continue block5;
                        file.LastAccessTime = fileTime;
                    }
                }
            }
        }

        private void readFileNames(ByteBuffer byteBuffer, List<FileItem> files) {
            for (FileItem file : files) {
                char c;
                StringBuilder stringBuilder = new StringBuilder();
                while ((c = byteBuffer.getChar()) != '\u0000') {
                    stringBuilder.append(c);
                }
                file.Name = stringBuilder.toString();
            }
        }

        private void readAndDecodePackedStreams(ByteBuffer byteBuffer, Reference<Long> baseOffset, Reference<Long> dataOffset, List<ByteBuffer> dataVector, InputStreamFactory inputStreamFactory) throws IOException {
            LinkedList<Long> packSizes = new LinkedList<Long>();
            LinkedList<Integer> packCRCs = new LinkedList<Integer>();
            LinkedList<Folder> folders = new LinkedList<Folder>();
            LinkedList<Integer> numUnPackStreamsInFolders = new LinkedList<Integer>();
            LinkedList<Long> unPackSizes = new LinkedList<Long>();
            LinkedList<Integer> digests = new LinkedList<Integer>();
            this.readStreamsInfo(byteBuffer, null, dataOffset, packSizes, packCRCs, folders, numUnPackStreamsInFolders, unPackSizes, digests);
            int packIndex = 0;
            Decoder decoder = new Decoder();
            long dataStartPos = (Long)baseOffset.getValue() + (Long)dataOffset.getValue();
            for (int i = 0; i < folders.size(); ++i) {
                Folder folder = (Folder)folders.get(i);
                long unPackSize = folder.getUnpackSize();
                if (unPackSize > Integer.MAX_VALUE) {
                    throw new ZipException("Bad header.");
                }
                if (unPackSize > Integer.MAX_VALUE) {
                    throw new ZipException("Bad header.");
                }
                ByteArrayOutputStream outStream = new ByteArrayOutputStream((int)unPackSize);
                decoder.Decode(inputStreamFactory, dataStartPos, packSizes.subList(packIndex, packSizes.size()), folder, new SequentialOutStreamWrapper(outStream), null);
                byte[] bytes = outStream.toByteArray();
                if (null != folder.UnpackCRC) {
                    CRC crc = new CRC();
                    crc.Update(bytes);
                    if (folder.UnpackCRC.intValue() != crc.GetDigest()) {
                        throw new ZipException("Bad header.");
                    }
                }
                dataVector.add(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
                for (int j = 0; j < folder.PackStreams.size(); ++j) {
                    dataStartPos += ((Long)packSizes.get(packIndex++)).longValue();
                }
            }
        }

        private void readArchiveProperties(ByteBuffer byteBuffer, InArchiveInfo archiveInfo) {
            long nBlockType;
            while (0L != (nBlockType = this.readId(byteBuffer))) {
                this.skipData(byteBuffer);
            }
        }

        private void readStreamsInfo(ByteBuffer byteBuffer, List<ByteBuffer> alternateByteBuffers, Reference<Long> dataOffsetRef, List<Long> packedStreamSizes, List<Integer> packedStreamDigests, List<Folder> folders, List<Integer> numUnpackStreamsInFolders, List<Long> unpackedStreamSizes, List<Integer> digests) throws ZipException {
            while (true) {
                long nBlockType;
                if (0L == (nBlockType = this.readId(byteBuffer))) {
                    return;
                }
                if (6L == nBlockType) {
                    this.readPackInfo(byteBuffer, dataOffsetRef, packedStreamSizes, packedStreamDigests);
                    continue;
                }
                if (7L == nBlockType) {
                    this.readUnpackInfo(byteBuffer, alternateByteBuffers, folders);
                    continue;
                }
                if (8L != nBlockType) break;
                this.readSubstreamsInfo(byteBuffer, folders, numUnpackStreamsInFolders, unpackedStreamSizes, digests);
            }
            throw new ZipException("Bad block type in header.");
        }

        private void readSubstreamsInfo(ByteBuffer byteBuffer, List<Folder> folders, List<Integer> numUnpackStreamsInFolders, List<Long> unpackedStreamSizes, List<Integer> digests) throws ZipException {
            int i;
            long type;
            numUnpackStreamsInFolders.clear();
            digests.clear();
            block0: while (true) {
                if ((type = this.readId(byteBuffer)) == 13L) {
                    i = 0;
                    while (true) {
                        if (i >= folders.size()) continue block0;
                        int value = this.readNum(byteBuffer);
                        numUnpackStreamsInFolders.add(value);
                        ++i;
                    }
                }
                if (type == 10L || type == 9L || type == 0L) break;
                this.skipData(byteBuffer);
            }
            if (numUnpackStreamsInFolders.isEmpty()) {
                for (i = 0; i < folders.size(); ++i) {
                    numUnpackStreamsInFolders.add(1);
                }
            }
            for (i = 0; i < numUnpackStreamsInFolders.size(); ++i) {
                int numSubstreams = numUnpackStreamsInFolders.get(i);
                if (numSubstreams == 0) continue;
                long sum = 0L;
                for (int j = 1; j < numSubstreams; ++j) {
                    if (type != 9L) continue;
                    long size = this.readNumber(byteBuffer);
                    unpackedStreamSizes.add(size);
                    sum += size;
                }
                unpackedStreamSizes.add(folders.get(i).getUnpackSize() - sum);
            }
            if (type == 9L) {
                type = this.readId(byteBuffer);
            }
            int numDigests = 0;
            int numDigestsTotal = 0;
            for (i = 0; i < folders.size(); ++i) {
                int numSubstreams = numUnpackStreamsInFolders.get(i);
                if (numSubstreams != 1 || null == folders.get((int)i).UnpackCRC) {
                    numDigests += numSubstreams;
                }
                numDigestsTotal += numSubstreams;
            }
            while (true) {
                if (type == 10L) {
                    ArrayList<Integer> digests2 = new ArrayList<Integer>(numDigests);
                    this.readHashDigests(byteBuffer, numDigests, digests2);
                    int digestIndex = 0;
                    for (i = 0; i < folders.size(); ++i) {
                        int numSubstreams = numUnpackStreamsInFolders.get(i);
                        Folder folder = folders.get(i);
                        if (numSubstreams == 1 && null != folder.UnpackCRC) {
                            digests.add(folder.UnpackCRC);
                            continue;
                        }
                        int j = 0;
                        while (j < numSubstreams) {
                            digests.add((Integer)digests2.get(digestIndex));
                            ++j;
                            ++digestIndex;
                        }
                    }
                } else {
                    if (type == 0L) {
                        if (digests.isEmpty()) {
                            for (int k = 0; k < numDigestsTotal; ++k) {
                                digests.add(null);
                            }
                        }
                        return;
                    }
                    this.skipData(byteBuffer);
                }
                type = this.readId(byteBuffer);
            }
        }

        private void readUnpackInfo(ByteBuffer byteBuffer, List<ByteBuffer> alternateByteBuffers, List<Folder> folders) throws ZipException {
            int i;
            Folder folder;
            this.skipToBlockType(byteBuffer, 11L);
            int numFolders = this.readNum(byteBuffer);
            ByteBuffer workingByteBuffer = this.chooseStream(byteBuffer, alternateByteBuffers);
            folders.clear();
            for (int nIndex = 0; nIndex < numFolders; ++nIndex) {
                folder = new Folder();
                folders.add(folder);
                this.readNextFolderItem(workingByteBuffer, folder);
            }
            this.skipToBlockType(byteBuffer, 12L);
            for (i = 0; i < numFolders; ++i) {
                folder = folders.get(i);
                int numOutStreams = folder.getNumOutStreams();
                for (int j = 0; j < numOutStreams; ++j) {
                    long unPackSize = this.readNumber(byteBuffer);
                    folder.UnpackSizes.add(unPackSize);
                }
            }
            long type;
            block3: while ((type = this.readId(byteBuffer)) != 0L) {
                if (type == 10L) {
                    ArrayList<Integer> crcs = new ArrayList<Integer>(numFolders);
                    this.readHashDigests(byteBuffer, numFolders, crcs);
                    i = 0;
                    while (true) {
                        if (i >= numFolders) continue block3;
                        Folder folder2 = folders.get(i);
                        folder2.UnpackCRC = (Integer)crcs.get(i);
                        ++i;
                    }
                }
                this.skipData(byteBuffer);
            }
            return;
        }

        private void readNextFolderItem(ByteBuffer byteBuffer, Folder folder) throws ZipException {
            int i;
            int numCoders = this.readNum(byteBuffer);
            folder.Coders.clear();
            int numInStreams = 0;
            int numOutStreams = 0;
            for (i = 0; i < numCoders; ++i) {
                byte mainByte;
                CoderInfo coder = new CoderInfo();
                folder.Coders.add(coder);
                do {
                    AltCoderInfo altCoder = new AltCoderInfo();
                    coder.AltCoders.add(altCoder);
                    mainByte = byteBuffer.get();
                    altCoder.MethodID.IDSize = (byte)(mainByte & 0xF);
                    altCoder.MethodID.ID = new byte[altCoder.MethodID.IDSize];
                    byteBuffer.get(altCoder.MethodID.ID);
                    if ((mainByte & 0x10) != 0) {
                        coder.NumInStreams = this.readNum(byteBuffer);
                        coder.NumOutStreams = this.readNum(byteBuffer);
                    } else {
                        coder.NumInStreams = 1;
                        coder.NumOutStreams = 1;
                    }
                    if ((mainByte & 0x20) == 0) continue;
                    int propertiesSize = this.readNum(byteBuffer);
                    altCoder.Properties = new byte[propertiesSize];
                    byteBuffer.get(altCoder.Properties);
                } while ((mainByte & 0x80) != 0);
                numInStreams += coder.NumInStreams;
                numOutStreams += coder.NumOutStreams;
            }
            int numBindPairs = numOutStreams - 1;
            folder.BindPairs.clear();
            for (i = 0; i < numBindPairs; ++i) {
                BindPair bindPair = new BindPair();
                bindPair.InIndex = this.readNum(byteBuffer);
                bindPair.OutIndex = this.readNum(byteBuffer);
                folder.BindPairs.add(bindPair);
            }
            int numPackedStreams = numInStreams - numBindPairs;
            if (numPackedStreams == 1) {
                for (int j = 0; j < numInStreams; ++j) {
                    if (folder.findBindPairForInStream(j) >= 0) continue;
                    folder.PackStreams.add(j);
                    break;
                }
            } else {
                for (i = 0; i < numPackedStreams; ++i) {
                    int packStreamInfo = this.readNum(byteBuffer);
                    folder.PackStreams.add(packStreamInfo);
                }
            }
        }

        private ByteBuffer chooseStream(ByteBuffer byteBuffer, List<ByteBuffer> alternateByteBuffers) throws ZipException {
            if (0 == byteBuffer.get()) {
                return byteBuffer;
            }
            return alternateByteBuffers.get(this.readNum(byteBuffer));
        }

        private void readPackInfo(ByteBuffer byteBuffer, Reference<Long> dataOffsetRef, List<Long> packSizes, List<Integer> packCRCs) throws ZipException {
            long nBlockType;
            dataOffsetRef.setValue((Object)this.readNumber(byteBuffer));
            int numPackStreams = this.readNum(byteBuffer);
            this.skipToBlockType(byteBuffer, 9L);
            packSizes.clear();
            for (int i = 0; i < numPackStreams; ++i) {
                packSizes.add(this.readNumber(byteBuffer));
            }
            boolean bHasCrcs = false;
            while (0L != (nBlockType = this.readId(byteBuffer))) {
                if (10L == nBlockType) {
                    this.readHashDigests(byteBuffer, numPackStreams, packCRCs);
                    bHasCrcs = true;
                    continue;
                }
                this.skipData(byteBuffer);
            }
            if (!bHasCrcs) {
                packCRCs.clear();
                for (int i = 0; i < numPackStreams; ++i) {
                    packCRCs.add(null);
                }
            }
        }

        private void readHashDigests(ByteBuffer byteBuffer, int nItems, List<Integer> digests) {
            digests.clear();
            ArrayList<Boolean> digestsDefined = new ArrayList<Boolean>(nItems);
            this.readBoolVector2(byteBuffer, nItems, digestsDefined);
            for (Boolean isDigestDefined : digestsDefined) {
                if (isDigestDefined.booleanValue()) {
                    digests.add(byteBuffer.getInt());
                    continue;
                }
                digests.add(null);
            }
        }

        private void readBoolVector(ByteBuffer byteBuffer, int nItems, List<Boolean> booleans) {
            booleans.clear();
            byte nValue = 0;
            int nMask = 0;
            for (int nIndex = 0; nIndex < nItems; ++nIndex) {
                if (0 == nMask) {
                    nValue = byteBuffer.get();
                    nMask = 128;
                }
                booleans.add(0 != (nValue & nMask));
                nMask >>>= 1;
            }
        }

        private void readBoolVector2(ByteBuffer byteBuffer, int nItems, List<Boolean> booleans) {
            byte nAllAreDefined = byteBuffer.get();
            if (0 == nAllAreDefined) {
                this.readBoolVector(byteBuffer, nItems, booleans);
            } else {
                booleans.clear();
                for (int nIndex = 0; nIndex < nItems; ++nIndex) {
                    booleans.add(true);
                }
            }
        }

        private boolean skipToBlockType(ByteBuffer byteBuffer, long nTargetBlockType) {
            long nBlockType;
            while (nTargetBlockType != (nBlockType = this.readId(byteBuffer))) {
                if (0L == nBlockType) {
                    return false;
                }
                this.skipData(byteBuffer);
            }
            return true;
        }

        private void skipData(ByteBuffer byteBuffer) {
            this.skipData(byteBuffer, this.readNumber(byteBuffer));
        }

        private void skipData(ByteBuffer byteBuffer, long nBytesToSkip) {
            if (nBytesToSkip > Integer.MAX_VALUE) {
                nBytesToSkip = Integer.MAX_VALUE;
            }
            byteBuffer.position(byteBuffer.position() + (int)nBytesToSkip);
        }

        private long readId(ByteBuffer byteBuffer) {
            return this.readNumber(byteBuffer);
        }

        private int readNum(ByteBuffer byteBuffer) throws ZipException {
            long nValue = this.readNumber(byteBuffer);
            if (nValue > Integer.MAX_VALUE) {
                throw new ZipException("Numeric value out of range.");
            }
            return (int)nValue;
        }

        private long readNumber(ByteBuffer byteBuffer) {
            byte nFirstByte = byteBuffer.get();
            int nMask = 128;
            long nValue = 0L;
            for (int nIndex = 0; nIndex < 8; ++nIndex) {
                if (0 == (nFirstByte & nMask)) {
                    long nHighPart = nFirstByte & nMask - 1;
                    nValue += nHighPart << nIndex * 8;
                    break;
                }
                byte b = byteBuffer.get();
                nValue |= ((long)b & 0xFFL) << 8 * nIndex;
                nMask >>>= 1;
            }
            return nValue;
        }
    }

    private static class BindPair {
        int InIndex;
        int OutIndex;

        private BindPair() {
        }
    }

    private static class MethodID {
        byte[] ID;
        byte IDSize;

        public MethodID() {
        }

        public MethodID(byte ... id) {
            this.ID = id;
            this.IDSize = (byte)id.length;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            MethodID methodID = (MethodID)that;
            if (this.IDSize != methodID.IDSize) {
                return false;
            }
            return Arrays.equals(this.ID, methodID.ID);
        }

        public int hashCode() {
            int result = this.IDSize;
            result = 29 * result + Arrays.hashCode(this.ID);
            return result;
        }
    }

    private static class AltCoderInfo {
        MethodID MethodID = new MethodID();
        byte[] Properties;

        private AltCoderInfo() {
        }
    }

    private static class CoderInfo {
        int NumInStreams;
        int NumOutStreams;
        List<AltCoderInfo> AltCoders = new LinkedList<AltCoderInfo>();

        private CoderInfo() {
        }

        public boolean isSimpleCoder() {
            return this.NumInStreams == 1 && this.NumOutStreams == 1;
        }
    }

    private static class FileItem {
        long CreationTime;
        long LastWriteTime;
        long LastAccessTime;
        long UnPackSize;
        long StartPos;
        int Attributes;
        Integer FileCRC;
        String Name;
        boolean HasStream;
        boolean IsDirectory;
        boolean IsAnti;
        boolean AreAttributesDefined;
        boolean IsCreationTimeDefined;
        boolean IsLastWriteTimeDefined;
        boolean IsLastAccessTimeDefined;
        boolean IsStartPosDefined;

        private FileItem() {
        }

        void setAttributes(int attributes) {
            this.AreAttributesDefined = true;
            this.Attributes = attributes;
        }

        void setCreationTime(long creationTime) {
            this.IsCreationTimeDefined = true;
            this.CreationTime = creationTime;
        }

        void setLastWriteTime(long lastWriteTime) {
            this.IsLastWriteTimeDefined = true;
            this.LastWriteTime = lastWriteTime;
        }

        void setLastAccessTime(long lastAccessTime) {
            this.IsLastAccessTimeDefined = true;
            this.LastAccessTime = lastAccessTime;
        }
    }

    private static class Folder {
        List<CoderInfo> Coders = new LinkedList<CoderInfo>();
        List<BindPair> BindPairs = new LinkedList<BindPair>();
        List<Integer> PackStreams = new LinkedList<Integer>();
        List<Long> UnpackSizes = new LinkedList<Long>();
        Integer UnpackCRC;

        private Folder() {
        }

        public long getUnpackSize() throws ZipException {
            if (this.UnpackSizes.isEmpty()) {
                return 0L;
            }
            for (int i = this.UnpackSizes.size() - 1; i >= 0; --i) {
                if (this.findBindPairForOutStream(i) >= 0) continue;
                return this.UnpackSizes.get(i);
            }
            throw new ZipException("Could not determine unpacked size for folder.");
        }

        public int getNumOutStreams() {
            int nResult = 0;
            for (CoderInfo Coder : this.Coders) {
                nResult += Coder.NumOutStreams;
            }
            return nResult;
        }

        public int findBindPairForInStream(long inStreamIndex) {
            for (int i = 0; i < this.BindPairs.size(); ++i) {
                if ((long)this.BindPairs.get((int)i).InIndex != inStreamIndex) continue;
                return i;
            }
            return -1;
        }

        private int findBindPairForOutStream(int outStreamIndex) {
            for (int i = 0; i < this.BindPairs.size(); ++i) {
                if (this.BindPairs.get((int)i).OutIndex != outStreamIndex) continue;
                return i;
            }
            return -1;
        }

        public int findPackStreamArrayIndex(int inStreamIndex) {
            for (int i = 0; i < this.PackStreams.size(); ++i) {
                if (this.PackStreams.get(i) != inStreamIndex) continue;
                return i;
            }
            return -1;
        }
    }

    private static class InArchiveInfo {
        ArchiveVersion Version = new ArchiveVersion();
        long StartPosition;
        long StartPositionAfterHeader;
        long DataStartPosition;
        long DataStartPosition2;
        List<Long> FileInfoPopIDs = new LinkedList<Long>();

        private InArchiveInfo() {
        }

        public void clear() {
            this.FileInfoPopIDs.clear();
        }
    }

    private static class ArchiveVersion {
        byte Major;
        byte Minor;

        private ArchiveVersion() {
        }
    }

    private static class ArchiveDatabaseEx
    extends ArchiveDatabase {
        InArchiveInfo ArchiveInfo = new InArchiveInfo();
        List<Long> PackStreamStartPositions = new LinkedList<Long>();
        List<Integer> FolderStartPackStreamIndex = new LinkedList<Integer>();
        List<Integer> FolderStartFileIndex = new LinkedList<Integer>();
        List<Integer> FileIndexToFolderIndexMap = new LinkedList<Integer>();

        private ArchiveDatabaseEx() {
        }

        @Override
        public void clear() {
            super.clear();
            this.ArchiveInfo.clear();
            this.PackStreamStartPositions.clear();
            this.FolderStartPackStreamIndex.clear();
            this.FolderStartFileIndex.clear();
            this.FileIndexToFolderIndexMap.clear();
        }

        public void fill() throws ZipException {
            this.fillFolderStartPackStream();
            this.fillStartPos();
            this.fillFolderStartFileIndex();
        }

        private void fillFolderStartPackStream() {
            this.FolderStartPackStreamIndex.clear();
            int startPos = 0;
            for (Folder Folder2 : this.Folders) {
                this.FolderStartPackStreamIndex.add(startPos);
                startPos += Folder2.PackStreams.size();
            }
        }

        private void fillStartPos() {
            this.PackStreamStartPositions.clear();
            long startPos = 0L;
            for (Long PackSize : this.PackSizes) {
                this.PackStreamStartPositions.add(startPos);
                startPos += PackSize.longValue();
            }
        }

        private void fillFolderStartFileIndex() throws ZipException {
            this.FolderStartFileIndex.clear();
            this.FileIndexToFolderIndexMap.clear();
            int folderIndex = 0;
            int indexInFolder = 0;
            for (int i = 0; i < this.Files.size(); ++i) {
                boolean emptyStream;
                FileItem file = (FileItem)this.Files.get(i);
                boolean bl = emptyStream = !file.HasStream;
                if (emptyStream && indexInFolder == 0) {
                    this.FileIndexToFolderIndexMap.add(-1);
                    continue;
                }
                if (indexInFolder == 0) {
                    while (true) {
                        if (folderIndex >= this.Folders.size()) {
                            throw new ZipException("Bad header.");
                        }
                        this.FolderStartFileIndex.add(i);
                        if ((Integer)this.NumUnpackStreamsVector.get(folderIndex) != 0) break;
                        ++folderIndex;
                    }
                }
                this.FileIndexToFolderIndexMap.add(folderIndex);
                if (emptyStream || ++indexInFolder < (Integer)this.NumUnpackStreamsVector.get(folderIndex)) continue;
                ++folderIndex;
                indexInFolder = 0;
            }
        }

        public long getFolderStreamPos(int folderIndex, int indexInFolder) {
            return this.ArchiveInfo.DataStartPosition + this.PackStreamStartPositions.get(this.FolderStartPackStreamIndex.get(folderIndex) + indexInFolder);
        }

        public long getFolderFullPackSize(int folderIndex) {
            int packStreamIndex = this.FolderStartPackStreamIndex.get(folderIndex);
            Folder folder = (Folder)this.Folders.get(folderIndex);
            long size = 0L;
            for (int i = 0; i < folder.PackStreams.size(); ++i) {
                size += ((Long)this.PackSizes.get(packStreamIndex + i)).longValue();
            }
            return size;
        }

        public long getFolderPackStreamSize(int folderIndex, int streamIndex) {
            return (Long)this.PackSizes.get(this.FolderStartPackStreamIndex.get(folderIndex) + streamIndex);
        }

        public long getFilePackSize(int fileIndex) {
            int folderIndex = this.FileIndexToFolderIndexMap.get(fileIndex);
            if (folderIndex >= 0 && this.FolderStartFileIndex.get(folderIndex) == fileIndex) {
                return this.getFolderFullPackSize(folderIndex);
            }
            return 0L;
        }
    }

    private static class ArchiveDatabase {
        List<Long> PackSizes = new LinkedList<Long>();
        List<Integer> PackCRCs = new LinkedList<Integer>();
        List<Folder> Folders = new LinkedList<Folder>();
        List<Integer> NumUnpackStreamsVector = new LinkedList<Integer>();
        List<FileItem> Files = new LinkedList<FileItem>();

        private ArchiveDatabase() {
        }

        public void clear() {
            this.PackSizes.clear();
            this.PackCRCs.clear();
            this.Folders.clear();
            this.NumUnpackStreamsVector.clear();
            this.Files.clear();
        }
    }

    private static interface BlockType {
        public static final int END = 0;
        public static final int HEADER = 1;
        public static final int ARCHIVE_PROPERTIES = 2;
        public static final int ADDITIONAL_STREAMS_INFO = 3;
        public static final int MAIN_STREAMS_INFO = 4;
        public static final int FILES_INFO = 5;
        public static final int PACK_INFO = 6;
        public static final int UNPACK_INFO = 7;
        public static final int SUBSTREAMS_INFO = 8;
        public static final int SIZE = 9;
        public static final int CRC = 10;
        public static final int FOLDER = 11;
        public static final int CODERS_UNPACK_SIZE = 12;
        public static final int NUM_UNPACK_STREAM = 13;
        public static final int EMPTY_STREAM = 14;
        public static final int EMPTY_FILE = 15;
        public static final int ANTI = 16;
        public static final int NAME = 17;
        public static final int CREATION_TIME = 18;
        public static final int LAST_ACCESS_TIME = 19;
        public static final int LAST_WRITE_TIME = 20;
        public static final int WIN_ATTRIBUTES = 21;
        public static final int COMMENT = 22;
        public static final int ENCODED_HEADER = 23;
        public static final int START_POS = 24;
    }
}

