/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ZipOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;
    protected int size;

    public ZipOutputStream(OutputStream out) {
        this(out, 512);
    }

    public ZipOutputStream(OutputStream out, int size) {
        super(out);
        this.size = size;
        this.buf = new byte[size];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.writeBuffer(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    private void writeBuffer(byte[] buf, int offset, int len) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(len / 2 + 1);
        Deflater deflater = new Deflater(9);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, deflater);
        dos.write(buf, offset, len);
        dos.finish();
        dos.flush();
        DataOutputStream dataOut = new DataOutputStream(this.out);
        byte[] nbuf = baos.toByteArray();
        dataOut.writeInt(nbuf.length);
        dataOut.write(nbuf, 0, nbuf.length);
        dataOut.flush();
        buf = new byte[this.size];
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.writeBuffer(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

