/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.common;

import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.BooleanUtils;
import java.time.Instant;

public class PrimitiveArrayConversionUtility {
    public static byte[] translateArrayBooleanToByte(Boolean[] array) {
        byte[] out = new byte[array.length];
        for (int ai = 0; ai < array.length; ++ai) {
            out[ai] = BooleanUtils.booleanAsByte((Boolean)array[ai]);
        }
        return out;
    }

    public static Boolean[] translateArrayByteToBoolean(byte[] array) {
        Boolean[] out = new Boolean[array.length];
        for (int ai = 0; ai < array.length; ++ai) {
            out[ai] = BooleanUtils.byteAsBoolean((byte)array[ai]);
        }
        return out;
    }

    public static long[] translateArrayInstantToLong(Instant[] array) {
        long[] out = new long[array.length];
        for (int ai = 0; ai < array.length; ++ai) {
            out[ai] = DateTimeUtils.epochNanos((Instant)array[ai]);
        }
        return out;
    }

    public static Instant[] translateArrayLongToInstant(long[] array) {
        Instant[] out = new Instant[array.length];
        for (int ai = 0; ai < array.length; ++ai) {
            out[ai] = DateTimeUtils.epochNanosToInstant((long)array[ai]);
        }
        return out;
    }

    public static Instant[] translateArrayStringToInstant(String[] array) {
        Instant[] out = new Instant[array.length];
        for (int ai = 0; ai < array.length; ++ai) {
            out[ai] = array[ai] == null ? null : DateTimeUtils.parseInstant((String)array[ai]);
        }
        return out;
    }
}

