/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.learn;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.integrations.learn.Future;
import io.deephaven.integrations.learn.FutureOffset;
import io.deephaven.integrations.learn.Input;
import io.deephaven.integrations.python.PythonFunctionCaller;
import java.util.ArrayList;
import java.util.function.Function;
import org.jpy.PyObject;

public class Computer {
    private final Function<Object[], Object> modelFunc;
    private final ColumnSource<?>[][] colSets;
    private final int batchSize;
    private final Input[] inputs;
    private Future current;
    private final ArrayList<FutureOffset> futureOffsets;
    private int offset;

    public Computer(Table table, PyObject modelFunc, Input[] inputs, int batchSize) {
        this(table, new PythonFunctionCaller((PyObject)Require.neqNull((Object)modelFunc, (String)"modelFunc")), inputs, batchSize);
    }

    public Computer(Table table, Function<Object[], Object> modelFunc, Input[] inputs, int batchSize) {
        Require.neqNull((Object)table, (String)"table");
        Require.neqNull(modelFunc, (String)"modelFunc");
        Require.neqNull((Object)inputs, (String)"inputs");
        Require.elementsNeqNull((Object[])inputs, (String)"inputs");
        Require.gtZero((int)batchSize, (String)"batchSize");
        this.modelFunc = modelFunc;
        this.batchSize = batchSize;
        this.inputs = inputs;
        this.colSets = new ColumnSource[this.inputs.length][];
        for (int i = 0; i < this.inputs.length; ++i) {
            this.colSets[i] = inputs[i].createColumnSource(table);
        }
        this.current = null;
        this.futureOffsets = new ArrayList(batchSize);
        this.offset = -1;
    }

    public boolean clear() {
        for (FutureOffset futureOffset : this.futureOffsets) {
            futureOffset.clear();
        }
        this.futureOffsets.clear();
        this.current = null;
        return false;
    }

    public FutureOffset compute(long k) {
        if (this.current == null || this.current.isFull()) {
            this.current = new Future(this.modelFunc, this.inputs, this.colSets, this.batchSize);
            this.offset = -1;
        }
        this.current.addRowKey(k);
        ++this.offset;
        FutureOffset fo = new FutureOffset(this.current, this.offset);
        this.futureOffsets.add(fo);
        return fo;
    }

    Future getFuture() {
        return this.current;
    }
}

