/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.learn;

import io.deephaven.base.verify.Assert;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderRandom;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.integrations.learn.Input;
import java.util.function.Function;

public class Future {
    private final Function<Object[], Object> func;
    private final Input[] inputs;
    private final ColumnSource<?>[][] colSets;
    private final int batchSize;
    private long count = 0L;
    private boolean rowSetBuilt = false;
    private RowSetBuilderRandom rowSetBuilder;
    private boolean called;
    private Object result;

    Future(Function<Object[], Object> func, Input[] inputs, ColumnSource<?>[][] colSets, int batchSize) {
        this.func = func;
        this.inputs = inputs;
        this.colSets = colSets;
        this.batchSize = batchSize;
        this.rowSetBuilder = RowSetFactory.builderRandom();
        this.called = false;
        this.result = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        if (!this.called) {
            try (RowSet rowSet = this.makeRowSet();){
                Object[] gathered = new Object[this.inputs.length];
                for (int i = 0; i < this.inputs.length; ++i) {
                    gathered[i] = this.gather(this.inputs[i], this.colSets[i], rowSet);
                }
                this.result = this.func.apply(gathered);
            }
            finally {
                this.rowSetBuilder = null;
                this.called = true;
            }
        }
        return this.result;
    }

    Object gather(Input input, ColumnSource<?>[] colSet, RowSet rowSet) {
        return input.getGatherFunc().apply(new Object[]{rowSet, colSet});
    }

    RowSet makeRowSet() {
        Assert.eqFalse((boolean)this.rowSetBuilt, (String)"RowSet has already been built");
        this.rowSetBuilt = true;
        return this.rowSetBuilder.build();
    }

    void addRowKey(long key) {
        Assert.eqFalse((boolean)this.rowSetBuilt, (String)"RowSet has already been built");
        Assert.assertion((!this.isFull() ? 1 : 0) != 0, (String)"Attempting to insert into a full Future");
        ++this.count;
        this.rowSetBuilder.addKey(key);
    }

    long size() {
        return this.count;
    }

    boolean isFull() {
        return this.size() >= (long)this.batchSize;
    }
}

