/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.learn;

import io.deephaven.api.util.NameValidator;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.integrations.python.PythonFunctionCaller;
import io.deephaven.util.annotations.ScriptApi;
import java.util.Arrays;
import java.util.function.Function;
import org.jpy.PyObject;

public class Input {
    private final String[] colNames;
    private final Function<Object[], Object> gatherFunc;

    public Input(String colName, PyObject gatherFunc) {
        this(new String[]{colName}, (Function<Object[], Object>)new PythonFunctionCaller((PyObject)Require.neqNull((Object)gatherFunc, (String)"gatherFunc")));
    }

    public Input(String[] colNames, PyObject gatherFunc) {
        this(colNames, (Function<Object[], Object>)new PythonFunctionCaller((PyObject)Require.neqNull((Object)gatherFunc, (String)"gatherFunc")));
    }

    public Input(String colName, Function<Object[], Object> gatherFunc) {
        this(new String[]{colName}, gatherFunc);
    }

    public Input(String[] colNames, Function<Object[], Object> gatherFunc) {
        Require.neqNull((Object)colNames, (String)"colNames");
        Require.neqNull(gatherFunc, (String)"gatherFunc");
        for (int i = 0; i < colNames.length; ++i) {
            NameValidator.validateColumnName((String)colNames[i]);
        }
        this.colNames = colNames;
        this.gatherFunc = gatherFunc;
    }

    ColumnSource<?>[] createColumnSource(Table table) {
        ColumnSource[] colSet = new ColumnSource[this.colNames.length];
        for (int i = 0; i < this.colNames.length; ++i) {
            colSet[i] = table.getColumnSource(this.colNames[i]);
        }
        return colSet;
    }

    Function<Object[], Object> getGatherFunc() {
        return this.gatherFunc;
    }

    @ScriptApi
    public String[] getColNames() {
        return this.colNames;
    }

    public String toString() {
        return "Input{colNames=" + Arrays.toString(this.colNames) + ", gatherFunc=" + this.gatherFunc + "}";
    }
}

