/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.learn;

import io.deephaven.api.util.NameValidator;
import io.deephaven.base.verify.Require;
import io.deephaven.integrations.python.PythonFunctionCaller;
import java.util.function.Function;
import org.jpy.PyObject;

public class Output {
    private final String colName;
    private final boolean isPythonScatterFunc;
    private final Function<Object[], Object> scatterFunc;
    private final String type;

    public Output(String colName, PyObject scatterFunc, String type) {
        this(colName, true, new PythonFunctionCaller((PyObject)Require.neqNull((Object)scatterFunc, (String)"scatterFunc")), type);
    }

    public Output(String colName, Function<Object[], Object> scatterFunc, String type) {
        this(colName, false, scatterFunc, type);
    }

    public Output(String colName, boolean isPythonScatterFunc, Function<Object[], Object> scatterFunc, String type) {
        Require.neqNull((Object)colName, (String)"colName");
        Require.neqNull(scatterFunc, (String)"scatterFunc");
        NameValidator.validateColumnName((String)colName);
        this.colName = colName;
        this.isPythonScatterFunc = isPythonScatterFunc;
        this.scatterFunc = scatterFunc;
        this.type = type;
    }

    public String getColName() {
        return this.colName;
    }

    public boolean isPythonScatterFunc() {
        return this.isPythonScatterFunc;
    }

    public Function<Object[], Object> getScatterFunc() {
        return this.scatterFunc;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "Output{colName='" + this.colName + "', isPythonScatterFunc=" + this.isPythonScatterFunc + ", scatterFunc=" + this.scatterFunc + ", type='" + this.type + "'}";
    }
}

