/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.learn;

import io.deephaven.base.verify.Require;
import io.deephaven.integrations.learn.FutureOffset;
import io.deephaven.integrations.learn.Output;

public class Scatterer {
    private final Output[] outputs;

    public Scatterer(Output[] outputs) {
        Require.neqNull((Object)outputs, (String)"outputs");
        Require.elementsNeqNull((Object[])outputs, (String)"outputs");
        this.outputs = outputs;
    }

    public Object scatter(int idx, FutureOffset fo) {
        return this.outputs[idx].getScatterFunc().apply(new Object[]{fo.getFuture().get(), fo.getOffset()});
    }

    public String[] generateQueryStrings(String futureOffsetColName) {
        String[] queryStrings = new String[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            String pyCast = this.outputs[i].isPythonScatterFunc() ? " (PyObject) " : "";
            String typeString = this.outputs[i].getType() == null ? pyCast : "(" + this.outputs[i].getType() + ")" + pyCast;
            queryStrings[i] = String.format("%s = %s (__scatterer.scatter(%d, %s))", this.outputs[i].getColName(), typeString, i, futureOffsetColName);
        }
        return queryStrings;
    }
}

