/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.learn.gather;

import io.deephaven.chunk.BooleanChunk;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ResettableWritableBooleanChunk;
import io.deephaven.chunk.ResettableWritableByteChunk;
import io.deephaven.chunk.ResettableWritableDoubleChunk;
import io.deephaven.chunk.ResettableWritableFloatChunk;
import io.deephaven.chunk.ResettableWritableIntChunk;
import io.deephaven.chunk.ResettableWritableLongChunk;
import io.deephaven.chunk.ResettableWritableShortChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.SharedContext;
import io.deephaven.util.SafeCloseableList;

public class NumPy {
    private static final int COPY_CHUNK_SIZE = 2048;

    public static boolean[] tensorBuffer2DBoolean(RowSequence rowSeq, ColumnSource<?>[] columnSources, boolean columnMajorOrder) {
        if (columnMajorOrder) {
            boolean[] tensor = NumPy.tensorBuffer2DBooleanColumnMajor(rowSeq, columnSources);
            return tensor;
        }
        boolean[] tensor = NumPy.tensorBuffer2DBooleanRowMajor(rowSeq, columnSources);
        return tensor;
    }

    private static boolean[] tensorBuffer2DBooleanColumnMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        boolean[] tensor = new boolean[nRows * nCols];
        try (ResettableWritableBooleanChunk valueChunk = ResettableWritableBooleanChunk.makeResettableChunk();
             SharedContext sharedContext = SharedContext.makeSharedContext();){
            for (int ci = 0; ci < nCols; ++ci) {
                valueChunk.resetFromArray((Object)tensor, ci * nRows, nRows);
                ColumnSource<?> colSrc = columnSources[ci];
                try (ChunkSource.FillContext fillContext = colSrc.makeFillContext(nRows, sharedContext);){
                    colSrc.fillChunk(fillContext, (WritableChunk)valueChunk, rowSeq);
                    continue;
                }
            }
        }
        return tensor;
    }

    private static boolean[] tensorBuffer2DBooleanRowMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        boolean[] tensor = new boolean[nRows * nCols];
        try (SafeCloseableList toClose = new SafeCloseableList();){
            RowSequence.Iterator rowKeys = (RowSequence.Iterator)toClose.add((AutoCloseable)rowSeq.getRowSequenceIterator());
            SharedContext inputSharedContext = (SharedContext)toClose.add((AutoCloseable)SharedContext.makeSharedContext());
            ChunkSource.GetContext[] inputContexts = (ChunkSource.GetContext[])toClose.addArray((AutoCloseable[])new ChunkSource.GetContext[nCols]);
            for (int ci = 0; ci < nCols; ++ci) {
                inputContexts[ci] = columnSources[ci].makeGetContext(2048, inputSharedContext);
            }
            BooleanChunk[] inputColumnValues = new BooleanChunk[nCols];
            int ti = 0;
            while (rowKeys.hasMore()) {
                RowSequence sliceRowKeys = rowKeys.getNextRowSequenceWithLength(2048L);
                for (int ci = 0; ci < nCols; ++ci) {
                    inputColumnValues[ci] = columnSources[ci].getChunk(inputContexts[ci], sliceRowKeys).asBooleanChunk();
                }
                int sliceChunkSize = sliceRowKeys.intSize();
                for (int ri = 0; ri < sliceChunkSize; ++ri) {
                    for (int ci = 0; ci < nCols; ++ci) {
                        tensor[ti++] = inputColumnValues[ci].get(ri);
                    }
                }
                inputSharedContext.reset();
            }
        }
        return tensor;
    }

    public static byte[] tensorBuffer2DByte(RowSequence rowSeq, ColumnSource<?>[] columnSources, boolean columnMajorOrder) {
        if (columnMajorOrder) {
            byte[] tensor = NumPy.tensorBuffer2DByteColumnMajor(rowSeq, columnSources);
            return tensor;
        }
        byte[] tensor = NumPy.tensorBuffer2DByteRowMajor(rowSeq, columnSources);
        return tensor;
    }

    private static byte[] tensorBuffer2DByteColumnMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        byte[] tensor = new byte[nRows * nCols];
        try (ResettableWritableByteChunk valueChunk = ResettableWritableByteChunk.makeResettableChunk();
             SharedContext sharedContext = SharedContext.makeSharedContext();){
            for (int ci = 0; ci < nCols; ++ci) {
                valueChunk.resetFromArray((Object)tensor, ci * nRows, nRows);
                ColumnSource<?> colSrc = columnSources[ci];
                try (ChunkSource.FillContext fillContext = colSrc.makeFillContext(nRows, sharedContext);){
                    colSrc.fillChunk(fillContext, (WritableChunk)valueChunk, rowSeq);
                    continue;
                }
            }
        }
        return tensor;
    }

    private static byte[] tensorBuffer2DByteRowMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        byte[] tensor = new byte[nRows * nCols];
        try (SafeCloseableList toClose = new SafeCloseableList();){
            RowSequence.Iterator rowKeys = (RowSequence.Iterator)toClose.add((AutoCloseable)rowSeq.getRowSequenceIterator());
            SharedContext inputSharedContext = (SharedContext)toClose.add((AutoCloseable)SharedContext.makeSharedContext());
            ChunkSource.GetContext[] inputContexts = (ChunkSource.GetContext[])toClose.addArray((AutoCloseable[])new ChunkSource.GetContext[nCols]);
            for (int ci = 0; ci < nCols; ++ci) {
                inputContexts[ci] = columnSources[ci].makeGetContext(2048, inputSharedContext);
            }
            ByteChunk[] inputColumnValues = new ByteChunk[nCols];
            int ti = 0;
            while (rowKeys.hasMore()) {
                RowSequence sliceRowKeys = rowKeys.getNextRowSequenceWithLength(2048L);
                for (int ci = 0; ci < nCols; ++ci) {
                    inputColumnValues[ci] = columnSources[ci].getChunk(inputContexts[ci], sliceRowKeys).asByteChunk();
                }
                int sliceChunkSize = sliceRowKeys.intSize();
                for (int ri = 0; ri < sliceChunkSize; ++ri) {
                    for (int ci = 0; ci < nCols; ++ci) {
                        tensor[ti++] = inputColumnValues[ci].get(ri);
                    }
                }
                inputSharedContext.reset();
            }
        }
        return tensor;
    }

    public static short[] tensorBuffer2DShort(RowSequence rowSeq, ColumnSource<?>[] columnSources, boolean columnMajorOrder) {
        if (columnMajorOrder) {
            short[] tensor = NumPy.tensorBuffer2DShortColumnMajor(rowSeq, columnSources);
            return tensor;
        }
        short[] tensor = NumPy.tensorBuffer2DShortRowMajor(rowSeq, columnSources);
        return tensor;
    }

    private static short[] tensorBuffer2DShortColumnMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        short[] tensor = new short[nRows * nCols];
        try (ResettableWritableShortChunk valueChunk = ResettableWritableShortChunk.makeResettableChunk();
             SharedContext sharedContext = SharedContext.makeSharedContext();){
            for (int ci = 0; ci < nCols; ++ci) {
                valueChunk.resetFromArray((Object)tensor, ci * nRows, nRows);
                ColumnSource<?> colSrc = columnSources[ci];
                try (ChunkSource.FillContext fillContext = colSrc.makeFillContext(nRows, sharedContext);){
                    colSrc.fillChunk(fillContext, (WritableChunk)valueChunk, rowSeq);
                    continue;
                }
            }
        }
        return tensor;
    }

    private static short[] tensorBuffer2DShortRowMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        short[] tensor = new short[nRows * nCols];
        try (SafeCloseableList toClose = new SafeCloseableList();){
            RowSequence.Iterator rowKeys = (RowSequence.Iterator)toClose.add((AutoCloseable)rowSeq.getRowSequenceIterator());
            SharedContext inputSharedContext = (SharedContext)toClose.add((AutoCloseable)SharedContext.makeSharedContext());
            ChunkSource.GetContext[] inputContexts = (ChunkSource.GetContext[])toClose.addArray((AutoCloseable[])new ChunkSource.GetContext[nCols]);
            for (int ci = 0; ci < nCols; ++ci) {
                inputContexts[ci] = columnSources[ci].makeGetContext(2048, inputSharedContext);
            }
            ShortChunk[] inputColumnValues = new ShortChunk[nCols];
            int ti = 0;
            while (rowKeys.hasMore()) {
                RowSequence sliceRowKeys = rowKeys.getNextRowSequenceWithLength(2048L);
                for (int ci = 0; ci < nCols; ++ci) {
                    inputColumnValues[ci] = columnSources[ci].getChunk(inputContexts[ci], sliceRowKeys).asShortChunk();
                }
                int sliceChunkSize = sliceRowKeys.intSize();
                for (int ri = 0; ri < sliceChunkSize; ++ri) {
                    for (int ci = 0; ci < nCols; ++ci) {
                        tensor[ti++] = inputColumnValues[ci].get(ri);
                    }
                }
                inputSharedContext.reset();
            }
        }
        return tensor;
    }

    public static int[] tensorBuffer2DInt(RowSequence rowSeq, ColumnSource<?>[] columnSources, boolean columnMajorOrder) {
        if (columnMajorOrder) {
            int[] tensor = NumPy.tensorBuffer2DIntColumnMajor(rowSeq, columnSources);
            return tensor;
        }
        int[] tensor = NumPy.tensorBuffer2DIntRowMajor(rowSeq, columnSources);
        return tensor;
    }

    private static int[] tensorBuffer2DIntColumnMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        int[] tensor = new int[nRows * nCols];
        try (ResettableWritableIntChunk valueChunk = ResettableWritableIntChunk.makeResettableChunk();
             SharedContext sharedContext = SharedContext.makeSharedContext();){
            for (int ci = 0; ci < nCols; ++ci) {
                valueChunk.resetFromArray((Object)tensor, ci * nRows, nRows);
                ColumnSource<?> colSrc = columnSources[ci];
                try (ChunkSource.FillContext fillContext = colSrc.makeFillContext(nRows, sharedContext);){
                    colSrc.fillChunk(fillContext, (WritableChunk)valueChunk, rowSeq);
                    continue;
                }
            }
        }
        return tensor;
    }

    private static int[] tensorBuffer2DIntRowMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        int[] tensor = new int[nRows * nCols];
        try (SafeCloseableList toClose = new SafeCloseableList();){
            RowSequence.Iterator rowKeys = (RowSequence.Iterator)toClose.add((AutoCloseable)rowSeq.getRowSequenceIterator());
            SharedContext inputSharedContext = (SharedContext)toClose.add((AutoCloseable)SharedContext.makeSharedContext());
            ChunkSource.GetContext[] inputContexts = (ChunkSource.GetContext[])toClose.addArray((AutoCloseable[])new ChunkSource.GetContext[nCols]);
            for (int ci = 0; ci < nCols; ++ci) {
                inputContexts[ci] = columnSources[ci].makeGetContext(2048, inputSharedContext);
            }
            IntChunk[] inputColumnValues = new IntChunk[nCols];
            int ti = 0;
            while (rowKeys.hasMore()) {
                RowSequence sliceRowKeys = rowKeys.getNextRowSequenceWithLength(2048L);
                for (int ci = 0; ci < nCols; ++ci) {
                    inputColumnValues[ci] = columnSources[ci].getChunk(inputContexts[ci], sliceRowKeys).asIntChunk();
                }
                int sliceChunkSize = sliceRowKeys.intSize();
                for (int ri = 0; ri < sliceChunkSize; ++ri) {
                    for (int ci = 0; ci < nCols; ++ci) {
                        tensor[ti++] = inputColumnValues[ci].get(ri);
                    }
                }
                inputSharedContext.reset();
            }
        }
        return tensor;
    }

    public static long[] tensorBuffer2DLong(RowSequence rowSeq, ColumnSource<?>[] columnSources, boolean columnMajorOrder) {
        if (columnMajorOrder) {
            long[] tensor = NumPy.tensorBuffer2DLongColumnMajor(rowSeq, columnSources);
            return tensor;
        }
        long[] tensor = NumPy.tensorBuffer2DLongRowMajor(rowSeq, columnSources);
        return tensor;
    }

    private static long[] tensorBuffer2DLongColumnMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        long[] tensor = new long[nRows * nCols];
        try (ResettableWritableLongChunk valueChunk = ResettableWritableLongChunk.makeResettableChunk();
             SharedContext sharedContext = SharedContext.makeSharedContext();){
            for (int ci = 0; ci < nCols; ++ci) {
                valueChunk.resetFromArray((Object)tensor, ci * nRows, nRows);
                ColumnSource<?> colSrc = columnSources[ci];
                try (ChunkSource.FillContext fillContext = colSrc.makeFillContext(nRows, sharedContext);){
                    colSrc.fillChunk(fillContext, (WritableChunk)valueChunk, rowSeq);
                    continue;
                }
            }
        }
        return tensor;
    }

    private static long[] tensorBuffer2DLongRowMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        long[] tensor = new long[nRows * nCols];
        try (SafeCloseableList toClose = new SafeCloseableList();){
            RowSequence.Iterator rowKeys = (RowSequence.Iterator)toClose.add((AutoCloseable)rowSeq.getRowSequenceIterator());
            SharedContext inputSharedContext = (SharedContext)toClose.add((AutoCloseable)SharedContext.makeSharedContext());
            ChunkSource.GetContext[] inputContexts = (ChunkSource.GetContext[])toClose.addArray((AutoCloseable[])new ChunkSource.GetContext[nCols]);
            for (int ci = 0; ci < nCols; ++ci) {
                inputContexts[ci] = columnSources[ci].makeGetContext(2048, inputSharedContext);
            }
            LongChunk[] inputColumnValues = new LongChunk[nCols];
            int ti = 0;
            while (rowKeys.hasMore()) {
                RowSequence sliceRowKeys = rowKeys.getNextRowSequenceWithLength(2048L);
                for (int ci = 0; ci < nCols; ++ci) {
                    inputColumnValues[ci] = columnSources[ci].getChunk(inputContexts[ci], sliceRowKeys).asLongChunk();
                }
                int sliceChunkSize = sliceRowKeys.intSize();
                for (int ri = 0; ri < sliceChunkSize; ++ri) {
                    for (int ci = 0; ci < nCols; ++ci) {
                        tensor[ti++] = inputColumnValues[ci].get(ri);
                    }
                }
                inputSharedContext.reset();
            }
        }
        return tensor;
    }

    public static float[] tensorBuffer2DFloat(RowSequence rowSeq, ColumnSource<?>[] columnSources, boolean columnMajorOrder) {
        if (columnMajorOrder) {
            float[] tensor = NumPy.tensorBuffer2DFloatColumnMajor(rowSeq, columnSources);
            return tensor;
        }
        float[] tensor = NumPy.tensorBuffer2DFloatRowMajor(rowSeq, columnSources);
        return tensor;
    }

    private static float[] tensorBuffer2DFloatColumnMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        float[] tensor = new float[nRows * nCols];
        try (ResettableWritableFloatChunk valueChunk = ResettableWritableFloatChunk.makeResettableChunk();
             SharedContext sharedContext = SharedContext.makeSharedContext();){
            for (int ci = 0; ci < nCols; ++ci) {
                valueChunk.resetFromArray((Object)tensor, ci * nRows, nRows);
                ColumnSource<?> colSrc = columnSources[ci];
                try (ChunkSource.FillContext fillContext = colSrc.makeFillContext(nRows, sharedContext);){
                    colSrc.fillChunk(fillContext, (WritableChunk)valueChunk, rowSeq);
                    continue;
                }
            }
        }
        return tensor;
    }

    private static float[] tensorBuffer2DFloatRowMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        float[] tensor = new float[nRows * nCols];
        try (SafeCloseableList toClose = new SafeCloseableList();){
            RowSequence.Iterator rowKeys = (RowSequence.Iterator)toClose.add((AutoCloseable)rowSeq.getRowSequenceIterator());
            SharedContext inputSharedContext = (SharedContext)toClose.add((AutoCloseable)SharedContext.makeSharedContext());
            ChunkSource.GetContext[] inputContexts = (ChunkSource.GetContext[])toClose.addArray((AutoCloseable[])new ChunkSource.GetContext[nCols]);
            for (int ci = 0; ci < nCols; ++ci) {
                inputContexts[ci] = columnSources[ci].makeGetContext(2048, inputSharedContext);
            }
            FloatChunk[] inputColumnValues = new FloatChunk[nCols];
            int ti = 0;
            while (rowKeys.hasMore()) {
                RowSequence sliceRowKeys = rowKeys.getNextRowSequenceWithLength(2048L);
                for (int ci = 0; ci < nCols; ++ci) {
                    inputColumnValues[ci] = columnSources[ci].getChunk(inputContexts[ci], sliceRowKeys).asFloatChunk();
                }
                int sliceChunkSize = sliceRowKeys.intSize();
                for (int ri = 0; ri < sliceChunkSize; ++ri) {
                    for (int ci = 0; ci < nCols; ++ci) {
                        tensor[ti++] = inputColumnValues[ci].get(ri);
                    }
                }
                inputSharedContext.reset();
            }
        }
        return tensor;
    }

    public static double[] tensorBuffer2DDouble(RowSequence rowSeq, ColumnSource<?>[] columnSources, boolean columnMajorOrder) {
        if (columnMajorOrder) {
            double[] tensor = NumPy.tensorBuffer2DDoubleColumnMajor(rowSeq, columnSources);
            return tensor;
        }
        double[] tensor = NumPy.tensorBuffer2DDoubleRowMajor(rowSeq, columnSources);
        return tensor;
    }

    private static double[] tensorBuffer2DDoubleColumnMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        double[] tensor = new double[nRows * nCols];
        try (ResettableWritableDoubleChunk valueChunk = ResettableWritableDoubleChunk.makeResettableChunk();
             SharedContext sharedContext = SharedContext.makeSharedContext();){
            for (int ci = 0; ci < nCols; ++ci) {
                valueChunk.resetFromArray((Object)tensor, ci * nRows, nRows);
                ColumnSource<?> colSrc = columnSources[ci];
                try (ChunkSource.FillContext fillContext = colSrc.makeFillContext(nRows, sharedContext);){
                    colSrc.fillChunk(fillContext, (WritableChunk)valueChunk, rowSeq);
                    continue;
                }
            }
        }
        return tensor;
    }

    private static double[] tensorBuffer2DDoubleRowMajor(RowSequence rowSeq, ColumnSource<?>[] columnSources) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        double[] tensor = new double[nRows * nCols];
        try (SafeCloseableList toClose = new SafeCloseableList();){
            RowSequence.Iterator rowKeys = (RowSequence.Iterator)toClose.add((AutoCloseable)rowSeq.getRowSequenceIterator());
            SharedContext inputSharedContext = (SharedContext)toClose.add((AutoCloseable)SharedContext.makeSharedContext());
            ChunkSource.GetContext[] inputContexts = (ChunkSource.GetContext[])toClose.addArray((AutoCloseable[])new ChunkSource.GetContext[nCols]);
            for (int ci = 0; ci < nCols; ++ci) {
                inputContexts[ci] = columnSources[ci].makeGetContext(2048, inputSharedContext);
            }
            DoubleChunk[] inputColumnValues = new DoubleChunk[nCols];
            int ti = 0;
            while (rowKeys.hasMore()) {
                RowSequence sliceRowKeys = rowKeys.getNextRowSequenceWithLength(2048L);
                for (int ci = 0; ci < nCols; ++ci) {
                    inputColumnValues[ci] = columnSources[ci].getChunk(inputContexts[ci], sliceRowKeys).asDoubleChunk();
                }
                int sliceChunkSize = sliceRowKeys.intSize();
                for (int ri = 0; ri < sliceChunkSize; ++ri) {
                    for (int ci = 0; ci < nCols; ++ci) {
                        tensor[ti++] = inputColumnValues[ci].get(ri);
                    }
                }
                inputSharedContext.reset();
            }
        }
        return tensor;
    }
}

