/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.integrations.python.PythonValueGetter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jpy.PyObject;

public class JavaLambdaFactory {
    public static <T> T create(Class<T> samInterface, PyObject callable, @Nullable Class<?> coerceToType) {
        MethodHandle helper;
        Set abstractMethods = Arrays.stream(samInterface.getMethods()).filter(m -> Modifier.isAbstract(m.getModifiers())).collect(Collectors.toSet());
        if (abstractMethods.isEmpty()) {
            throw new IllegalArgumentException("Provided interface " + samInterface + " has zero abstract methods");
        }
        if (abstractMethods.size() > 1) {
            throw new IllegalArgumentException("Provided interface " + samInterface + " has too many abstract methods: " + abstractMethods);
        }
        if (coerceToType == null) {
            coerceToType = Object.class;
        }
        MethodHandles.Lookup caller = MethodHandles.lookup();
        try {
            helper = caller.findStatic(JavaLambdaFactory.class, "invoke", MethodType.methodType(Object.class, PyObject.class, Class.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("Internal error, failed to find JavaLambdaFactory.invoke() method", e);
        }
        MethodHandle closeOnCallable = MethodHandles.insertArguments(helper, 0, callable, coerceToType);
        MethodHandle nonVarArgs = closeOnCallable.asVarargsCollector(Object[].class);
        return MethodHandleProxies.asInterfaceInstance(samInterface, nonVarArgs);
    }

    private static Object invoke(PyObject callable, Class<?> coerceToType, Object ... args) {
        PyObject out = callable.call("__call__", args);
        if (coerceToType != null) {
            return PythonValueGetter.getValue(out, coerceToType);
        }
        return out;
    }
}

