/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jpy.PyObject;

public class PyLogOutputStream
extends OutputStream {
    private final Supplier<PyObject> rawIoBaseSupplier;

    public PyLogOutputStream(Supplier<PyObject> rawIoBaseSupplier) {
        this.rawIoBaseSupplier = rawIoBaseSupplier;
    }

    @Override
    public void write(int i) throws IOException {
        this.write(new byte[]{(byte)i});
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        this.rawIoBaseSupplier.get().callMethod("write", new Object[]{new String(b)});
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        byte[] buffer = new byte[len];
        System.arraycopy(b, off, buffer, 0, len);
        this.write(buffer);
    }

    @Override
    public void flush() throws IOException {
        this.rawIoBaseSupplier.get().callMethod("flush", new Object[0]);
    }

    @Override
    public void close() throws IOException {
        this.rawIoBaseSupplier.get().callMethod("close", new Object[0]);
    }
}

