/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.integrations.python.PythonObjectWrapper;
import io.deephaven.integrations.python.PythonUtils;
import io.deephaven.integrations.python.PythonValueGetter;
import io.deephaven.util.annotations.ScriptApi;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import org.jpy.PyObject;

@ScriptApi
public class PythonBiFunction<T, U, R>
implements BiFunction<T, U, R> {
    private final PyObject pyCallable;
    private final Class<R> classOut;

    public PythonBiFunction(PyObject pyCallable, Class<R> classOut) {
        this.pyCallable = PythonUtils.pyApplyFunc(pyCallable);
        this.classOut = classOut;
    }

    @Override
    public R apply(T t, U u) {
        PyObject wrapped = PythonObjectWrapper.wrap(t);
        PyObject wrappedOther = PythonObjectWrapper.wrap(u);
        PyObject out = this.pyCallable.call("__call__", new Object[]{wrapped, wrappedOther});
        return PythonValueGetter.getValue(out, this.classOut);
    }

    public static class PythonBinaryOperator<T>
    extends PythonBiFunction<T, T, T>
    implements BinaryOperator<T> {
        public PythonBinaryOperator(PyObject pyCallable, Class<T> classOut) {
            super(pyCallable, classOut);
        }
    }
}

