/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.base.FileUtils;
import io.deephaven.base.verify.Assert;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.exceptions.CancellationException;
import io.deephaven.engine.updategraph.OperationInitializer;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.util.AbstractScriptSession;
import io.deephaven.engine.util.PythonEvaluator;
import io.deephaven.engine.util.PythonEvaluatorJpy;
import io.deephaven.engine.util.PythonScope;
import io.deephaven.engine.util.ScriptFinder;
import io.deephaven.engine.util.ScriptSession;
import io.deephaven.integrations.python.PythonObjectWrapper;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.plugin.type.ObjectTypeLookup;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.ScriptApi;
import io.deephaven.util.thread.NamingThreadFactory;
import io.deephaven.util.thread.ThreadInitializationFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jpy.KeyError;
import org.jpy.PyDictWrapper;
import org.jpy.PyInputMode;
import org.jpy.PyLib;
import org.jpy.PyModule;
import org.jpy.PyObject;

public class PythonDeephavenSession
extends AbstractScriptSession<PythonSnapshot> {
    private static final Logger log = LoggerFactory.getLogger(PythonDeephavenSession.class);
    private static final String DEFAULT_SCRIPT_PATH = Configuration.getInstance().getStringWithDefault("PythonDeephavenSession.defaultScriptPath", ".");
    public static String SCRIPT_TYPE = "Python";
    private final PythonEvaluator evaluator;
    private final PythonScope<PyObject> scope;
    private final PythonScriptSessionModule module;
    private final ScriptFinder scriptFinder;

    public PythonDeephavenSession(UpdateGraph updateGraph, OperationInitializer operationInitializer, ThreadInitializationFactory threadInitializationFactory, ObjectTypeLookup objectTypeLookup, @Nullable ScriptSession.Listener listener, boolean runInitScripts, PythonEvaluatorJpy pythonEvaluator) throws IOException {
        super(updateGraph, operationInitializer, objectTypeLookup, listener);
        this.evaluator = pythonEvaluator;
        this.scope = pythonEvaluator.getScope();
        this.executionContext.getQueryLibrary().importClass(PyObject.class);
        try (SafeCloseable ignored = this.executionContext.open();){
            this.module = (PythonScriptSessionModule)PyModule.importModule((String)"deephaven_internal.script_session").createProxy(PyLib.CallableKind.FUNCTION, new Class[]{PythonScriptSessionModule.class});
        }
        this.scriptFinder = new ScriptFinder(DEFAULT_SCRIPT_PATH);
        this.registerJavaExecutor(threadInitializationFactory);
        this.publishInitial();
        if (runInitScripts) {
            String[] scripts;
            for (String script : scripts = Configuration.getInstance().getProperty("PythonDeephavenSession.initScripts").split(",")) {
                this.runScript(script);
            }
        }
    }

    public PythonDeephavenSession(UpdateGraph updateGraph, OperationInitializer operationInitializer, ThreadInitializationFactory threadInitializationFactory, PythonScope<?> scope) {
        super(updateGraph, operationInitializer, (ObjectTypeLookup)ObjectTypeLookup.NoOp.INSTANCE, null);
        this.evaluator = null;
        this.scope = scope;
        try (SafeCloseable ignored = this.executionContext.open();){
            this.module = (PythonScriptSessionModule)PyModule.importModule((String)"deephaven_internal.script_session").createProxy(PyLib.CallableKind.FUNCTION, new Class[]{PythonScriptSessionModule.class});
        }
        this.scriptFinder = null;
        this.registerJavaExecutor(threadInitializationFactory);
        this.publishInitial();
    }

    private void registerJavaExecutor(final ThreadInitializationFactory threadInitializationFactory) {
        try (PyModule pyModule = PyModule.importModule((String)"deephaven.server.executors");
             PythonDeephavenThreadsModule module = (PythonDeephavenThreadsModule)pyModule.createProxy(PythonDeephavenThreadsModule.class);){
            NamingThreadFactory threadFactory = new NamingThreadFactory(PythonDeephavenSession.class, "serverThread"){

                public Thread newThread(@NotNull Runnable r) {
                    return super.newThread(threadInitializationFactory.createInitializer(r));
                }
            };
            ExecutorService executorService = Executors.newFixedThreadPool(1, (ThreadFactory)threadFactory);
            module._register_named_java_executor("serial", executorService::submit);
            module._register_named_java_executor("concurrent", executorService::submit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript(String script) throws IOException {
        ScriptFinder.FileOrStream file = this.scriptFinder.findScriptEx(script);
        if (file.getFile().isPresent()) {
            this.evaluator.runScript(((File)file.getFile().get()).getAbsolutePath());
        } else {
            Assert.assertion((boolean)file.getStream().isPresent(), (String)"file.getStream().isPresent()");
            String scriptText = FileUtils.readTextFile((InputStream)((InputStream)file.getStream().get()));
            Path f = Files.createTempFile("PythonDeephavenSession", ".py", new FileAttribute[0]);
            try (FileWriter fileWriter = new FileWriter(f.toFile());){
                fileWriter.write(scriptText);
                fileWriter.close();
                this.evaluator.runScript(f.toFile().getAbsolutePath());
            }
            finally {
                Files.delete(f);
            }
        }
    }

    protected <T> T getVariable(String name) throws QueryScope.MissingVariableException {
        return this.scope.getValue(name).orElseThrow(() -> new QueryScope.MissingVariableException("Missing variable " + name));
    }

    @ScriptApi
    public void pushScope(PyObject pydict) {
        if (!pydict.isDict()) {
            throw new IllegalArgumentException("Expect a Python dict but got a" + pydict.repr());
        }
        this.scope.pushScope(pydict);
    }

    @ScriptApi
    public void popScope() {
        this.scope.popScope();
    }

    protected void evaluate(String command, String scriptName) {
        log.info().append((CharSequence)("Evaluating command: " + command)).endl();
        try {
            ExecutionContext.getContext().getUpdateGraph().exclusiveLock().doLockedInterruptibly(() -> this.evaluator.evalScript(command));
        }
        catch (InterruptedException e) {
            throw new CancellationException(e.getMessage() != null ? e.getMessage() : "Query interrupted", (Throwable)e);
        }
    }

    protected PythonSnapshot emptySnapshot() {
        return new PythonSnapshot(PyObject.executeCode((String)"dict()", (PyInputMode)PyInputMode.EXPRESSION).asDict());
    }

    protected PythonSnapshot takeSnapshot() {
        return new PythonSnapshot(this.scope.mainGlobals().copy());
    }

    protected ScriptSession.Changes createDiff(PythonSnapshot from, PythonSnapshot to, RuntimeException e) {
        try (PyObject changes = this.module.create_change_list(from.dict.unwrap(), to.dict.unwrap());){
            ScriptSession.Changes diff = new ScriptSession.Changes();
            diff.error = e;
            for (PyObject change : changes.asList()) {
                String name = (String)change.call(String.class, "__getitem__", Integer.TYPE, (Object)0);
                PyObject fromValue = (PyObject)change.call(PyObject.class, "__getitem__", Integer.TYPE, (Object)1);
                PyObject toValue = (PyObject)change.call(PyObject.class, "__getitem__", Integer.TYPE, (Object)2);
                this.applyVariableChangeToDiff(diff, name, this.unwrapObject(fromValue), this.unwrapObject(toValue));
            }
            ScriptSession.Changes changes2 = diff;
            return changes2;
        }
    }

    protected Set<String> getVariableNames() {
        try (PyDictWrapper currScope = this.scope.currentScope().copy();){
            Set<String> set = currScope.keySet().stream().map(arg_0 -> this.scope.convertStringKey(arg_0)).collect(Collectors.toSet());
            return set;
        }
    }

    protected boolean hasVariable(String name) {
        return this.scope.containsKey(name);
    }

    protected synchronized Object setVariable(String name, @Nullable Object newValue) {
        Object old = PyLib.ensureGil(() -> {
            PyDictWrapper globals = this.scope.mainGlobals();
            if (newValue == null) {
                try {
                    return globals.unwrap().callMethod("pop", new Object[]{name});
                }
                catch (KeyError key) {
                    return null;
                }
            }
            Object wrapped = newValue instanceof PyObject ? newValue : PythonObjectWrapper.wrap(newValue);
            PyObject prev = globals.get(name);
            globals.setItem((Object)name, wrapped);
            return prev;
        });
        this.observeScopeChanges();
        return old;
    }

    protected <T> Map<String, T> getAllValues(@Nullable Function<Object, T> valueMapper, @NotNull QueryScope.ParamFilter<T> filter) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (PyDictWrapper currScope = this.scope.currentScope().copy();){
            for (Map.Entry entry : currScope.entrySet()) {
                String name = this.scope.convertStringKey((Object)((PyObject)entry.getKey()));
                Object value = this.scope.convertValue((Object)((PyObject)entry.getValue()));
                if (valueMapper != null) {
                    value = valueMapper.apply(value);
                }
                if (!filter.accept(name, value)) continue;
                result.put(name, value);
            }
        }
        return result;
    }

    public String scriptType() {
        return SCRIPT_TYPE;
    }

    public Object unwrapObject(@Nullable Object object) {
        PyObject pyObject;
        Object unwrapped;
        if (object instanceof PyObject && (unwrapped = this.module.javaify(pyObject = (PyObject)object)) != null) {
            return unwrapped;
        }
        return object;
    }

    static interface PythonDeephavenThreadsModule
    extends Closeable {
        @Override
        public void close();

        public void _register_named_java_executor(String var1, Consumer<Runnable> var2);
    }

    static interface PythonScriptSessionModule
    extends Closeable {
        public PyObject create_change_list(PyObject var1, PyObject var2);

        public Object javaify(PyObject var1);

        @Override
        public void close();
    }

    protected static class PythonSnapshot
    implements AbstractScriptSession.Snapshot,
    SafeCloseable {
        private final PyDictWrapper dict;

        public PythonSnapshot(PyDictWrapper dict) {
            this.dict = Objects.requireNonNull(dict);
        }

        public void close() {
            this.dict.close();
        }
    }
}

