/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.integrations.python.PythonObjectWrapper;
import io.deephaven.integrations.python.PythonUtils;
import io.deephaven.integrations.python.PythonValueGetter;
import io.deephaven.util.annotations.ScriptApi;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jpy.PyObject;

@ScriptApi
public class PythonFunction<T, R>
implements Function<T, R> {
    private final PyObject pyCallable;
    private final Class<R> classOut;

    public PythonFunction(PyObject pyCallable, Class<R> classOut) {
        this.pyCallable = PythonUtils.pyApplyFunc(pyCallable);
        this.classOut = classOut;
    }

    @Override
    public R apply(T t) {
        PyObject wrapped = PythonObjectWrapper.wrap(t);
        PyObject out = this.pyCallable.call("__call__", new Object[]{wrapped});
        return PythonValueGetter.getValue(out, this.classOut);
    }

    public static class PythonUnaryOperator<T>
    extends PythonFunction<T, T>
    implements UnaryOperator<T> {
        public PythonUnaryOperator(PyObject pyCallable, Class<T> classOut) {
            super(pyCallable, classOut);
        }
    }
}

