/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ResettableWritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.SharedContext;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PythonListenerTableUpdateDataReader {
    public static io.deephaven.engine.table.Context makeContext(int chunkCapacity, ColumnSource<?> ... columnSources) {
        return new Context(chunkCapacity, columnSources);
    }

    public static Object[] readChunkColumnMajor(@NotNull io.deephaven.engine.table.Context context, RowSequence rowSeq, ColumnSource<?>[] columnSources, boolean prev) {
        int nRows = rowSeq.intSize();
        int nCols = columnSources.length;
        Object[] arrays = Arrays.stream(columnSources).map(cs -> {
            ChunkType chunkType = cs.getChunkType();
            if (chunkType == ChunkType.Object) {
                return Array.newInstance(cs.getType(), rowSeq.intSize());
            }
            return cs.getChunkType().makeArray(rowSeq.intSize());
        }).toArray(Object[]::new);
        Context typedContext = (Context)context;
        for (int ci = 0; ci < nCols; ++ci) {
            ChunkSource.FillContext fillContext = typedContext.fillContexts[ci];
            ResettableWritableChunk<Values> chunk = typedContext.resettableChunks[ci];
            Object array = arrays[ci];
            chunk.resetFromArray(array, 0, nRows);
            ColumnSource<?> colSrc = columnSources[ci];
            if (prev) {
                colSrc.fillPrevChunk(fillContext, chunk, rowSeq);
            } else {
                colSrc.fillChunk(fillContext, chunk, rowSeq);
            }
            chunk.clear();
        }
        typedContext.sharedContext.reset();
        return arrays;
    }

    private static class Context
    implements io.deephaven.engine.table.Context {
        private final SharedContext sharedContext = SharedContext.makeSharedContext();
        private final ChunkSource.FillContext[] fillContexts;
        private final ResettableWritableChunk<Values>[] resettableChunks;

        private Context(int chunkCapacity, ColumnSource<?> ... columnSources) {
            this.fillContexts = (ChunkSource.FillContext[])Arrays.stream(columnSources).map(cs -> cs.makeFillContext(chunkCapacity, this.sharedContext)).toArray(ChunkSource.FillContext[]::new);
            this.resettableChunks = (ResettableWritableChunk[])Arrays.stream(columnSources).map(cs -> cs.getChunkType().makeResettableWritableChunk()).toArray(ResettableWritableChunk[]::new);
        }

        public void close() {
            this.sharedContext.close();
            for (ChunkSource.FillContext fillContext : this.fillContexts) {
                fillContext.close();
            }
            for (ChunkSource.FillContext fillContext : this.resettableChunks) {
                fillContext.close();
            }
        }
    }
}

