/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.RowSetShiftData;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.ModifiedColumnSet;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableUpdate;
import io.deephaven.engine.table.impl.InstrumentedTableUpdateListenerAdapter;
import io.deephaven.engine.table.impl.TableUpdateImpl;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.integrations.python.PythonUtils;
import io.deephaven.integrations.python.TableSnapshotReplayer;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.ScriptApi;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.jpy.PyObject;

@ScriptApi
public class PythonReplayListenerAdapter
extends InstrumentedTableUpdateListenerAdapter
implements TableSnapshotReplayer {
    private static final long serialVersionUID = -8882402061960621245L;
    private final PyObject pyCallable;
    private final NotificationQueue.Dependency[] dependencies;

    public static PythonReplayListenerAdapter create(@Nullable String description, Table source, boolean retain, PyObject pyObjectIn, NotificationQueue.Dependency ... dependencies) {
        UpdateGraph updateGraph = source.getUpdateGraph(dependencies);
        try (SafeCloseable ignored = ExecutionContext.getContext().withUpdateGraph(updateGraph).open();){
            PythonReplayListenerAdapter pythonReplayListenerAdapter = new PythonReplayListenerAdapter(description, source, retain, pyObjectIn, dependencies);
            return pythonReplayListenerAdapter;
        }
    }

    private PythonReplayListenerAdapter(@Nullable String description, Table source, boolean retain, PyObject pyObjectIn, NotificationQueue.Dependency ... dependencies) {
        super(description, source, retain);
        this.dependencies = dependencies;
        this.pyCallable = PythonUtils.pyListenerFunc(pyObjectIn);
    }

    @Override
    public void replay() {
        WritableRowSet emptyRowSet = RowSetFactory.empty();
        RowSetShiftData emptyShift = RowSetShiftData.EMPTY;
        ModifiedColumnSet emptyColumnSet = ModifiedColumnSet.EMPTY;
        TableUpdateImpl update = new TableUpdateImpl((RowSet)this.source.getRowSet(), (RowSet)emptyRowSet, (RowSet)emptyRowSet, emptyShift, emptyColumnSet);
        boolean isReplay = true;
        this.pyCallable.call("__call__", new Object[]{update, true});
    }

    public void onUpdate(TableUpdate update) {
        boolean isReplay = false;
        this.pyCallable.call("__call__", new Object[]{update, false});
    }

    public boolean canExecute(long step) {
        return super.canExecute(step) && (this.dependencies.length == 0 || Arrays.stream(this.dependencies).allMatch(t -> t.satisfied(step)));
    }
}

