/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.ShiftObliviousInstrumentedListenerAdapter;
import io.deephaven.integrations.python.PythonUtils;
import io.deephaven.integrations.python.TableSnapshotReplayer;
import io.deephaven.util.annotations.ScriptApi;
import org.jpy.PyObject;

@ScriptApi
public class PythonReplayShiftObliviousListenerAdapter
extends ShiftObliviousInstrumentedListenerAdapter
implements TableSnapshotReplayer {
    private static final long serialVersionUID = -356456046697273581L;
    private final PyObject pyCallable;

    public PythonReplayShiftObliviousListenerAdapter(Table source, PyObject pyObjectIn) {
        this(null, source, true, pyObjectIn);
    }

    public PythonReplayShiftObliviousListenerAdapter(String description, Table source, PyObject pyObjectIn) {
        this(description, source, true, pyObjectIn);
    }

    public PythonReplayShiftObliviousListenerAdapter(String description, Table source, boolean retain, PyObject pyObjectIn) {
        super(description, source, retain);
        this.pyCallable = PythonUtils.pyListenerFunc(pyObjectIn);
    }

    @Override
    public void replay() {
        WritableRowSet emptyRowSet = RowSetFactory.empty();
        boolean isReplay = true;
        this.pyCallable.call("__call__", new Object[]{true, this.source.getRowSet(), emptyRowSet, emptyRowSet});
    }

    public void onUpdate(RowSet added, RowSet removed, RowSet modified) {
        boolean isReplay = false;
        this.pyCallable.call("__call__", new Object[]{false, added, removed, modified});
    }
}

