/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.util.annotations.ScriptApi;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;

@ScriptApi
public class PythonTimeComponents {
    @ScriptApi
    public static int[] getLocalTimeComponents(LocalTime dt) {
        return new int[]{dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getNano()};
    }

    @ScriptApi
    public static int[] getLocalTimeComponents(ZonedDateTime dt) {
        return PythonTimeComponents.getLocalTimeComponents(dt.toLocalTime());
    }

    @ScriptApi
    public static long[] getInstantComponents(Instant dt) {
        return new long[]{dt.getEpochSecond(), dt.getNano()};
    }

    @ScriptApi
    public static long[] getInstantComponents(ZonedDateTime dt) {
        return new long[]{dt.toEpochSecond(), dt.getNano()};
    }

    @ScriptApi
    public static long[] getDurationComponents(Duration dt) {
        return new long[]{dt.getSeconds(), dt.getNano()};
    }

    @ScriptApi
    public static int[] getPeriodComponents(Period dt) {
        return new int[]{dt.getYears(), dt.getMonths(), dt.getDays()};
    }

    @ScriptApi
    public static int[] getLocalDateComponents(LocalDate dt) {
        return new int[]{dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth()};
    }

    @ScriptApi
    public static int[] getLocalDateComponents(ZonedDateTime dt) {
        return PythonTimeComponents.getLocalDateComponents(dt.toLocalDate());
    }
}

