/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.integrations.python;

import io.deephaven.integrations.python.PythonObjectWrapper;
import org.jpy.PyObject;

class PythonValueGetter {
    PythonValueGetter() {
    }

    static Object getObject(PyObject valueIn) {
        if (valueIn == null) {
            return null;
        }
        return PythonObjectWrapper.unwrap(valueIn);
    }

    static String getString(PyObject valueIn) {
        if (valueIn == null) {
            return null;
        }
        return valueIn.getStringValue();
    }

    static double getDouble(PyObject valueIn) {
        if (valueIn == null) {
            return -1.7976931348623157E308;
        }
        return valueIn.getDoubleValue();
    }

    static float getFloat(PyObject valueIn) {
        if (valueIn == null) {
            return -3.4028235E38f;
        }
        return (float)valueIn.getDoubleValue();
    }

    static long getLong(PyObject valueIn) {
        if (valueIn == null) {
            return Long.MIN_VALUE;
        }
        return valueIn.getLongValue();
    }

    static int getInt(PyObject valueIn) {
        if (valueIn == null) {
            return Integer.MIN_VALUE;
        }
        long ll = valueIn.getLongValue();
        if ((long)((int)ll) != ll) {
            throw new ArithmeticException("The PyObject value is outside Integer range.");
        }
        return (int)ll;
    }

    static short getShort(PyObject valueIn) {
        if (valueIn == null) {
            return Short.MIN_VALUE;
        }
        long ll = valueIn.getLongValue();
        if ((long)((short)ll) != ll) {
            throw new ArithmeticException("The PyObject value is outside Short range.");
        }
        return (short)ll;
    }

    static byte getByte(PyObject valueIn) {
        if (valueIn == null) {
            return -128;
        }
        long ll = valueIn.getLongValue();
        if ((long)((byte)ll) != ll) {
            throw new ArithmeticException("The PyObject value is outside Byte range.");
        }
        return (byte)ll;
    }

    static Boolean getBoolean(PyObject valueIn) {
        if (valueIn == null) {
            return null;
        }
        return valueIn.getBooleanValue();
    }

    static <R> R getValue(PyObject pyObject, Class<R> classOut) {
        Object result = CharSequence.class.isAssignableFrom(classOut) ? PythonValueGetter.getString(pyObject) : (classOut.equals(Double.class) || classOut.equals(Double.TYPE) ? Double.valueOf(PythonValueGetter.getDouble(pyObject)) : (classOut.equals(Float.class) || classOut.equals(Float.TYPE) ? Float.valueOf(PythonValueGetter.getFloat(pyObject)) : (classOut.equals(Long.class) || classOut.equals(Long.TYPE) ? Long.valueOf(PythonValueGetter.getLong(pyObject)) : (classOut.equals(Integer.class) || classOut.equals(Integer.TYPE) ? Integer.valueOf(PythonValueGetter.getInt(pyObject)) : (classOut.equals(Short.class) || classOut.equals(Short.TYPE) ? Short.valueOf(PythonValueGetter.getShort(pyObject)) : (classOut.equals(Byte.class) || classOut.equals(Byte.TYPE) ? Byte.valueOf(PythonValueGetter.getByte(pyObject)) : (classOut.equals(Boolean.class) || classOut.equals(Boolean.TYPE) ? PythonValueGetter.getBoolean(pyObject) : PythonValueGetter.getObject(pyObject))))))));
        return (R)result;
    }
}

