/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.numerics.derivatives;

import org.apache.commons.math3.distribution.NormalDistribution;

public class BlackScholes {
    private static final double EPS = 1.0E-8;
    private static final int MAX_ITERS = 10000;
    private static final NormalDistribution nd = new NormalDistribution();

    private BlackScholes() {
    }

    public static double price(boolean isCall, double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        double d2 = d1 - v * Math.sqrt(T);
        if (isCall) {
            return S * Math.exp((b - r) * T) * BlackScholes.CND(d1) - X * Math.exp(-r * T) * BlackScholes.CND(d2);
        }
        return X * Math.exp(-r * T) * BlackScholes.CND(-d2) - S * Math.exp((b - r) * T) * BlackScholes.CND(-d1);
    }

    public static double delta(boolean isCall, double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        if (isCall) {
            return Math.exp((b - r) * T) * BlackScholes.CND(d1);
        }
        return Math.exp((b - r) * T) * (BlackScholes.CND(d1) - 1.0);
    }

    public static double gamma(double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        return nd.density(d1) * Math.exp((b - r) * T) / (S * v * Math.sqrt(T));
    }

    public static double gammaP(double S, double X, double T, double r, double b, double v) {
        return BlackScholes.gamma(S, X, T, r, b, v) * S;
    }

    public static double vega(double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        return S * Math.exp((b - r) * T) * nd.density(d1) * Math.sqrt(T);
    }

    public static double vegaP(double S, double X, double T, double r, double b, double v) {
        return v * BlackScholes.vega(S, X, T, r, b, v);
    }

    public static double vomma(double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        double d2 = d1 - v * Math.sqrt(T);
        return BlackScholes.vega(S, X, T, r, b, v) * d1 * d2 / v;
    }

    public static double vommaP(double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        double d2 = d1 - v * Math.sqrt(T);
        return BlackScholes.vegaP(S, X, T, r, b, v) * d1 * d2 / v;
    }

    public static double vegaBleed(double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        double d2 = d1 - v * Math.sqrt(T);
        return BlackScholes.vega(S, X, T, r, b, v) * (r - b + b * d1 / (v * Math.sqrt(T)) - (1.0 + d1 * d2) / (2.0 * T));
    }

    public static double charm(boolean isCall, double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        double d2 = d1 - v * Math.sqrt(T);
        if (isCall) {
            return -Math.exp((b - r) * T) * (nd.density(d1) * (b / (v * Math.sqrt(T)) - d2 / (2.0 * T)) + (b - r) * BlackScholes.CND(d1));
        }
        return -Math.exp((b - r) * T) * (nd.density(d1) * (b / (v * Math.sqrt(T)) - d2 / (2.0 * T)) - (b - r) * BlackScholes.CND(-d1));
    }

    public static double theta(boolean isCall, double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        double d2 = d1 - v * Math.sqrt(T);
        if (isCall) {
            return -S * Math.exp((b - r) * T) * nd.density(d1) * v / (2.0 * Math.sqrt(T)) - (b - r) * S * Math.exp((b - r) * T) * BlackScholes.CND(d1) - r * X * Math.exp(-r * T) * BlackScholes.CND(d2);
        }
        return -S * Math.exp((b - r) * T) * nd.density(d1) * v / (2.0 * Math.sqrt(T)) + (b - r) * S * Math.exp((b - r) * T) * BlackScholes.CND(-d1) + r * X * Math.exp(-r * T) * BlackScholes.CND(-d2);
    }

    public static double driftlessTheta(double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        return -S * nd.density(d1) * v / (2.0 * Math.sqrt(T));
    }

    public static double rho(boolean isCall, double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        double d2 = d1 - v * Math.sqrt(T);
        if (isCall) {
            return T * X * Math.exp(-r * T) * BlackScholes.CND(d2);
        }
        return -T * X * Math.exp(-r * T) * BlackScholes.CND(-d2);
    }

    public static double carryRho(boolean isCall, double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        if (isCall) {
            return T * S * Math.exp((b - r) * T) * BlackScholes.CND(d1);
        }
        return -T * S * Math.exp((b - r) * T) * BlackScholes.CND(-d1);
    }

    public static double strikeDelta(boolean isCall, double S, double X, double T, double r, double b, double v) {
        double d1 = (Math.log(S / X) + (b + v * v / 2.0) * T) / (v * Math.sqrt(T));
        double d2 = d1 - v * Math.sqrt(T);
        if (isCall) {
            return -Math.exp(-r * T) * BlackScholes.CND(d2);
        }
        return Math.exp(-r * T) * BlackScholes.CND(-d2);
    }

    public static double impliedVolBisect(double P, Boolean isCall, double S, double X, double T, double r, double b) {
        return BlackScholes.impliedVolBisect(P, isCall, S, X, T, r, b, 1.0E-8, 10000);
    }

    public static double impliedVolBisect(double P, Boolean isCall, double S, double X, double T, double r, double b, double eps, int maxIters) {
        if (P == -1.7976931348623157E308 || isCall == null || S == -1.7976931348623157E308 || X == -1.7976931348623157E308 || T == -1.7976931348623157E308 || r == -1.7976931348623157E308 || b == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        if (P == 0.0) {
            return 0.0;
        }
        if (Double.isNaN(P * S * X * T * r * b)) {
            return Double.NaN;
        }
        double vLow = 1.0E-4;
        double vHigh = 10.0;
        for (int i = 0; i < maxIters; ++i) {
            double vi = vLow + 0.5 * (vHigh - vLow);
            double pi = BlackScholes.price(isCall, S, X, T, r, b, vi);
            if (P < pi) {
                vHigh = vi;
            } else {
                vLow = vi;
            }
            if (!(Math.abs(vHigh - vLow) < eps)) continue;
            return vi;
        }
        return 0.5 * (vLow + vHigh);
    }

    public static double impliedVolNewton(double P, Boolean isCall, double S, double X, double T, double r, double b) {
        return BlackScholes.impliedVolNewton(P, isCall, S, X, T, r, b, 1.0E-8, 10000);
    }

    public static double impliedVolNewton(double P, Boolean isCall, double S, double X, double T, double r, double b, double eps, int maxIters) {
        if (P == -1.7976931348623157E308 || isCall == null || S == -1.7976931348623157E308 || X == -1.7976931348623157E308 || T == -1.7976931348623157E308 || r == -1.7976931348623157E308 || b == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        if (P == 0.0) {
            return 0.0;
        }
        if (Double.isNaN(P * S * X * T * r * b)) {
            return Double.NaN;
        }
        double vol = 0.4;
        for (int i = 0; i < maxIters; ++i) {
            double price = BlackScholes.price(isCall, S, X, T, r, b, vol);
            double vega = BlackScholes.vega(S, X, T, r, b, vol);
            double dvol = -(price - P) / vega;
            double adjDvol = Math.min(dvol, 0.5 * vol);
            vol += adjDvol;
            if (!(Math.abs(adjDvol) < eps)) continue;
            return vol;
        }
        return vol;
    }

    public static double impliedVolNewtonP(double P, Boolean isCall, double S, double X, double T, double r, double b) {
        return BlackScholes.impliedVolNewtonP(P, isCall, S, X, T, r, b, 1.0E-8, 10000);
    }

    public static double impliedVolNewtonP(double P, Boolean isCall, double S, double X, double T, double r, double b, double eps, int maxIters) {
        if (P == -1.7976931348623157E308 || isCall == null || S == -1.7976931348623157E308 || X == -1.7976931348623157E308 || T == -1.7976931348623157E308 || r == -1.7976931348623157E308 || b == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        if (P == 0.0) {
            return 0.0;
        }
        if (Double.isNaN(P * S * X * T * r * b)) {
            return Double.NaN;
        }
        double vol = 0.4;
        double lnvol = Math.log(vol);
        double volOld = 1000.0;
        for (int i = 0; i < maxIters; ++i) {
            double vegaP;
            double price = BlackScholes.price(isCall, S, X, T, r, b, vol);
            double dlnvol = -(price - P) / (vegaP = vol * BlackScholes.vega(S, X, T, r, b, vol));
            double adjDlnvol = Math.signum(dlnvol) * Math.min(Math.abs(dlnvol), 0.5);
            vol = Math.exp(lnvol += adjDlnvol);
            if (Math.abs(vol - volOld) < eps) {
                return vol;
            }
            volOld = vol;
        }
        return vol;
    }

    public static double strikeFromDeltaBisect(double delta, Boolean isCall, double S, double T, double r, double b, double v) {
        return BlackScholes.strikeFromDeltaBisect(delta, isCall, S, T, r, b, v, 1.0E-8, 10000);
    }

    public static double strikeFromDeltaBisect(double delta, Boolean isCall, double S, double T, double r, double b, double v, double eps, int maxIters) {
        if (delta == -1.7976931348623157E308 || isCall == null || S == -1.7976931348623157E308 || v == -1.7976931348623157E308 || T == -1.7976931348623157E308 || r == -1.7976931348623157E308 || b == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        if (Double.isNaN(delta * S * v * T * r * b)) {
            return Double.NaN;
        }
        double xLow = 1.0E-6;
        double xHigh = 1000000.0;
        for (int i = 0; i < maxIters; ++i) {
            double xi = xLow + 0.5 * (xHigh - xLow);
            double di = BlackScholes.delta(isCall, S, xi, T, r, b, v);
            if (delta > di) {
                xHigh = xi;
            } else {
                xLow = xi;
            }
            if (!(Math.abs(xHigh - xLow) < eps)) continue;
            return xi;
        }
        return 0.5 * (xLow + xHigh);
    }

    private static double CND(double X) {
        double a1 = 0.31938153;
        double a2 = -0.356563782;
        double a3 = 1.781477937;
        double a4 = -1.821255978;
        double a5 = 1.330274429;
        double L = Math.abs(X);
        double K = 1.0 / (1.0 + 0.2316419 * L);
        double w = 1.0 - 1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-L * L / 2.0) * (0.31938153 * K + -0.356563782 * K * K + 1.781477937 * Math.pow(K, 3.0) + -1.821255978 * Math.pow(K, 4.0) + 1.330274429 * Math.pow(K, 5.0));
        if (X < 0.0) {
            return 1.0 - w;
        }
        return w;
    }
}

