/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.numerics.interpolation;

import Jama.Matrix;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class Interpolator {
    private Interpolator() {
    }

    /*
     * WARNING - void declaration
     */
    public static double[] interpolate(double[] x, double[] y, double[] xi, InterpolationAlgorithm method, boolean extrapolate) {
        void var7_12;
        int i;
        if (xi.length == 0) {
            return new double[0];
        }
        int n = ((Object)y).length;
        if (((Object)y).length != ((Object)x).length) {
            throw new IllegalArgumentException("X and Y are different lengths: " + ((Object)x).length + "," + ((Object)y).length);
        }
        if (Interpolator.containsInfinityOrNanOrNull(x)) {
            throw new IllegalArgumentException("X contains Inf or NaNs or Nulls! " + Arrays.toString(x));
        }
        if (Interpolator.containsInfinityOrNanOrNull(y)) {
            throw new IllegalArgumentException("Y contains Inf or NaNs or Nulls! " + Arrays.toString(y));
        }
        if (n < 2) {
            if (xi.length == 0) {
                return new double[0];
            }
            throw new IllegalArgumentException("At least 2 data points are needed to interpolate");
        }
        double[] h = Interpolator.diff(x);
        if (Interpolator.containsNegative(h)) {
            double[][] dArray = Interpolator.sort(x, y);
            x = dArray[0];
            y = dArray[1];
            h = Interpolator.diff(x);
        }
        for (double hi : h) {
            if (hi != 0.0) continue;
            throw new IllegalArgumentException("The values of X should be distinct");
        }
        int[] p = new int[xi.length];
        for (i = 0; i < p.length; ++i) {
            p[i] = i;
        }
        block0 : switch (method) {
            case SPLINE: {
                double[] dArray = Interpolator.piecewiseCubicHermiteInterpolation(x, y, xi, new SplineDerivativeCalculator());
                break;
            }
            case PCHIP: {
                double[] dArray = Interpolator.piecewiseCubicHermiteInterpolation(x, y, xi, new PchipDerivativeCalculator());
                break;
            }
            default: {
                double[] dArray = new double[xi.length];
                if (Interpolator.containsNegative(Interpolator.diff(xi))) {
                    double[] pd = new double[xi.length];
                    for (int i3 = 0; i3 < pd.length; ++i3) {
                        pd[i3] = i3;
                    }
                    double[][] sortTemp = Interpolator.sort(xi, pd);
                    xi = sortTemp[0];
                    for (int i4 = 0; i4 < p.length; ++i4) {
                        p[i4] = (int)sortTemp[1][i4];
                    }
                } else {
                    for (i = 0; i < p.length; ++i) {
                        p[i] = i;
                    }
                }
                int[] k = Interpolator.getBin(xi, x);
                for (int i2 = 0; i2 < xi.length; ++i2) {
                    if (xi[i2] < x[0]) {
                        k[i2] = 0;
                    }
                    if (!(xi[i2] >= x[((double[])x).length - 1])) continue;
                    k[i2] = n - 2;
                }
                switch (method) {
                    case NEAREST: {
                        int i2;
                        for (i2 = 0; i2 < xi.length; ++i2) {
                            if (xi[i2] >= (x[k[i2]] + x[k[i2] + 1]) / 2.0) {
                                k[i2] = k[i2] + 1;
                            }
                            dArray[p[i2]] = y[k[i2]];
                        }
                        break block0;
                    }
                    case LINEAR: {
                        int i2;
                        for (i2 = 0; i2 < xi.length; ++i2) {
                            double s = (xi[i2] - x[k[i2]]) / h[k[i2]];
                            dArray[p[i2]] = y[k[i2]] + s * (y[k[i2] + 1] - y[k[i2]]);
                        }
                        break block0;
                    }
                    default: {
                        throw new UnsupportedOperationException("Interpolation method is not yet supported: " + method);
                    }
                }
            }
        }
        if (!extrapolate) {
            for (int i5 = 0; i5 < xi.length; ++i5) {
                if (!(xi[i5] < x[0]) && !(xi[i5] > x[n - 1])) continue;
                var7_12[p[i5]] = Double.NaN;
            }
        }
        for (int i6 = 0; i6 < xi.length; ++i6) {
            if (xi[i6] != -1.7976931348623157E308) continue;
            var7_12[i6] = -1.7976931348623157E308;
        }
        return var7_12;
    }

    private static double[] diff(double[] v) {
        double[] result = new double[v.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v[i + 1] - v[i];
        }
        return result;
    }

    private static double[][] sort(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y are not the same length: " + x.length + "," + y.length);
        }
        TreeMap<Double, Integer> map = new TreeMap<Double, Integer>();
        for (int i = 0; i < x.length; ++i) {
            map.put(x[i], i);
        }
        if (map.size() != x.length) {
            throw new IllegalArgumentException("X values are repeated!");
        }
        double[][] result = new double[2][x.length];
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            result[0][index] = (Double)entry.getKey();
            result[1][index] = y[(Integer)entry.getValue()];
            ++index;
        }
        return result;
    }

    private static boolean containsNegative(double[] x) {
        for (double xi : x) {
            if (!(xi < 0.0)) continue;
            return true;
        }
        return false;
    }

    private static double[] piecewiseCubicHermiteInterpolation(double[] x, double[] y, double[] xi, InterpolationDerivativeCalculator derivativeCalculator) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y are different lengths: " + x.length + "," + y.length);
        }
        if (x.length == 0) {
            throw new IllegalArgumentException("Inputs data is of zero length.");
        }
        if (x.length == 1) {
            double[] result = new double[xi.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = y[0];
            }
            return result;
        }
        if (x.length == 2) {
            double m = (y[0] - y[1]) / (x[0] - x[1]);
            double[] result = new double[xi.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = m * (xi[i] - x[0]) + y[0];
            }
            return result;
        }
        double[] h = Interpolator.diff(x);
        double[] delta = Interpolator.diff(y);
        for (int i = 0; i < delta.length; ++i) {
            delta[i] = delta[i] / h[i];
        }
        double[] d = derivativeCalculator.computeDerivatives(x, y, h, delta);
        if (d.length != x.length) {
            throw new IllegalStateException("Hermite derivative vector is the wrong length: " + d.length + " != " + x.length + " " + derivativeCalculator.getClass());
        }
        int[] k = Interpolator.getBin(xi, x);
        double[] yi = new double[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            double yk = y[k[i]];
            double dk = d[k[i]];
            double ck = (3.0 * delta[k[i]] - 2.0 * d[k[i]] - d[k[i] + 1]) / h[k[i]];
            double bk = (d[k[i]] - 2.0 * delta[k[i]] + d[k[i] + 1]) / h[k[i]] / h[k[i]];
            double s = xi[i] - x[k[i]];
            yi[i] = yk + s * dk + s * s * ck + s * s * s * bk;
        }
        return yi;
    }

    private static int[] getBin(double[] xi, double[] x) {
        int[] bin = new int[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            for (int k = 0; k < x.length - 1; ++k) {
                if (!(x[k] <= xi[i]) || !(xi[i] < x[k + 1])) continue;
                bin[i] = k;
            }
            if (x[x.length - 1] <= xi[i]) {
                bin[i] = x.length - 2;
            }
            if (!(x[0] > xi[i])) continue;
            bin[i] = 0;
        }
        return bin;
    }

    private static boolean containsInfinityOrNanOrNull(double[] v) {
        for (int i = 0; i < v.length; ++i) {
            double w = v[i];
            if (!Double.isInfinite(w) && !Double.isNaN(w) && !Interpolator.isNull(w)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNull(double w) {
        return w == -1.7976931348623157E308;
    }

    private static class SplineDerivativeCalculator
    implements InterpolationDerivativeCalculator {
        private SplineDerivativeCalculator() {
        }

        @Override
        public double[] computeDerivatives(double[] x, double[] y, double[] h, double[] delta) {
            double[][] a = new double[delta.length + 1][delta.length + 1];
            a[0][0] = h[1];
            a[0][1] = h[1] + h[0];
            a[delta.length][delta.length] = h[delta.length - 1];
            a[delta.length][delta.length - 1] = h[delta.length - 2] + h[delta.length - 1];
            for (int i = 1; i < delta.length; ++i) {
                a[i][i - 1] = h[1];
                a[i][i] = 2.0 * (h[i - 1] + h[i]);
                a[i][i + 1] = h[i - 1];
            }
            double[][] r = new double[delta.length + 1][1];
            r[0][0] = ((h[0] + 2.0 * (h[0] + h[1])) * h[1] * delta[0] + h[0] * h[0] * delta[1]) / (h[0] + h[1]);
            r[delta.length][0] = (h[h.length - 1] * h[h.length - 1] * delta[h.length - 2] + (2.0 * (h[h.length - 2] + h[h.length - 1]) + h[h.length - 1]) * h[h.length - 2] * delta[h.length - 1]) / (h[h.length - 2] + h[h.length - 1]);
            for (int i = 1; i < delta.length; ++i) {
                r[i][0] = 3.0 * (h[i] * delta[i - 1] + h[i - 1] * delta[i]);
            }
            Matrix A = new Matrix(a);
            Matrix R = new Matrix(r);
            Matrix D = A.solve(R);
            double[] d = new double[D.getRowDimension()];
            for (int i = 0; i < d.length; ++i) {
                d[i] = D.get(i, 0);
            }
            return d;
        }
    }

    private static class PchipDerivativeCalculator
    implements InterpolationDerivativeCalculator {
        private PchipDerivativeCalculator() {
        }

        @Override
        public double[] computeDerivatives(double[] x, double[] y, double[] h, double[] delta) {
            double[] d = new double[x.length];
            for (int i = 1; i < x.length - 1; ++i) {
                if (delta[i] * delta[i - 1] <= 0.0) {
                    d[i] = 0.0;
                    continue;
                }
                double w1 = 2.0 * h[i] + h[i - 1];
                double w2 = h[i] + 2.0 * h[i - 1];
                double rhs = w1 / delta[i - 1] + w2 / delta[i];
                double sum = w1 + w1;
                d[i] = sum / rhs;
            }
            d[0] = this.computeDeriviativeBoundaryValue(h[0], h[1], delta[0], delta[1]);
            d[d.length - 1] = this.computeDeriviativeBoundaryValue(h[h.length - 1], h[h.length - 2], delta[delta.length - 1], delta[delta.length - 2]);
            return d;
        }

        private double computeDeriviativeBoundaryValue(double h1, double h2, double delta1, double delta2) {
            double d = ((2.0 * h1 + h2) * delta1 - h1 * delta2) / (h1 + h2);
            if (d * delta1 < 0.0) {
                d = 0.0;
            } else if (delta1 * delta2 < 0.0 && Math.abs(d) > Math.abs(3.0 * delta1)) {
                d = 3.0 * delta1;
            }
            return d;
        }
    }

    private static interface InterpolationDerivativeCalculator {
        public double[] computeDerivatives(double[] var1, double[] var2, double[] var3, double[] var4);
    }

    public static enum InterpolationAlgorithm {
        NEAREST,
        LINEAR,
        PCHIP,
        SPLINE;

    }
}

