/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.numerics.movingaverages;

import java.io.Serializable;

public abstract class AbstractMa
implements Serializable {
    private static final long serialVersionUID = -4154939937570732234L;
    protected final Type type;
    protected final Mode mode;
    protected double timeScale;
    protected long lastTimestamp = Long.MIN_VALUE;
    protected double lastSample = Double.NaN;

    protected AbstractMa() {
        this.type = Type.LEVEL;
        this.mode = Mode.TICK;
    }

    public AbstractMa(Type type, Mode mode, double timeScale) {
        this.type = type;
        this.mode = mode;
        this.timeScale = timeScale;
    }

    public void processDouble(long timestamp, double data) {
        this.processDoubleLocal(timestamp, data);
        this.lastTimestamp = timestamp;
        this.lastSample = data;
    }

    protected abstract void processDoubleLocal(long var1, double var3);

    public abstract double getCurrent();

    public abstract void setCurrent(double var1);

    public double getTimeScale() {
        return this.timeScale;
    }

    public abstract void reset();

    public void setTimeScale(double timeScale) {
        this.timeScale = timeScale;
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public double getLastSample() {
        return this.lastSample;
    }

    public static enum Mode {
        TICK,
        TIME;

    }

    public static enum Type {
        LEVEL,
        DIFFERENCE;

    }
}

