/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.numerics.movingaverages;

import io.deephaven.base.verify.Require;
import io.deephaven.function.Basic;
import io.deephaven.numerics.movingaverages.AbstractMa;
import io.deephaven.time.DateTimeUtils;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class ByEma
implements Serializable {
    private static final long serialVersionUID = -6541641502689292655L;
    private final BadDataBehavior nullBehavior;
    private final BadDataBehavior nanBehavior;
    private final Map<Key, AbstractMa> emas = new HashMap<Key, AbstractMa>();

    protected ByEma(BadDataBehavior nullBehavior, BadDataBehavior nanBehavior) {
        this.nullBehavior = nullBehavior;
        this.nanBehavior = nanBehavior;
        Require.neqNull((Object)((Object)nullBehavior), (String)"nullBehavior");
        Require.neqNull((Object)((Object)nanBehavior), (String)"nanBehavior");
    }

    public synchronized double update(double value) {
        return this.update(value, new Object[]{null});
    }

    public synchronized double update(double value, Object ... by) {
        return this.update(Long.MIN_VALUE, value, by);
    }

    public synchronized double update(Instant timestamp, double value) {
        return this.update(timestamp, value, new Object[]{null});
    }

    public synchronized double update(Instant timestamp, double value, Object ... by) {
        return this.update(DateTimeUtils.epochNanos((Instant)timestamp), value, by);
    }

    public synchronized double update(long timestampNanos, double value, Object ... by) {
        return this.updateInternal(timestampNanos, value, Basic.isNull((double)value), Double.isNaN(value), by);
    }

    private static boolean resetEma(boolean isNull, BadDataBehavior nullBehavior, boolean isNaN, BadDataBehavior nanBehavior) {
        return isNull && nullBehavior.reset || isNaN && nanBehavior.reset;
    }

    private static boolean returnNan(boolean isNull, BadDataBehavior nullBehavior, boolean isNaN, BadDataBehavior nanBehavior) {
        return isNull && nullBehavior.returnNan || isNaN && nanBehavior.returnNan;
    }

    private static boolean processSample(boolean isNull, BadDataBehavior nullBehavior, boolean isNaN, BadDataBehavior nanBehavior) {
        return !isNull && !isNaN || isNull && nullBehavior.process || isNaN && nanBehavior.process;
    }

    private synchronized double updateInternal(long timestampNanos, double value, boolean isNull, boolean isNaN, Object ... by) {
        Key key = new Key(by);
        AbstractMa ema = this.emas.get(key);
        if (ema == null || ByEma.resetEma(isNull, this.nullBehavior, isNaN, this.nanBehavior)) {
            ema = this.createEma(key);
            this.emas.put(key, ema);
        }
        if (ByEma.processSample(isNull, this.nullBehavior, isNaN, this.nanBehavior)) {
            ema.processDouble(timestampNanos, value);
        }
        return ByEma.returnNan(isNull, this.nullBehavior, isNaN, this.nanBehavior) ? Double.NaN : ema.getCurrent();
    }

    protected abstract AbstractMa createEma(Key var1);

    public static enum BadDataBehavior {
        BD_RESET(true, false, true),
        BD_SKIP(false, false, false),
        BD_PROCESS(false, true, false);

        private final boolean reset;
        private final boolean process;
        private final boolean returnNan;

        private BadDataBehavior(boolean reset, boolean process, boolean returnNan) {
            this.reset = reset;
            this.process = process;
            this.returnNan = returnNan;
        }
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = 8481816497504935854L;
        final Object[] values;

        public Key(Object ... values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Arrays.equals(this.values, key.values);
        }

        public int hashCode() {
            return this.values != null ? Arrays.hashCode(this.values) : 0;
        }

        public String toString() {
            return "Key{values=" + (this.values == null ? null : Arrays.asList(this.values)) + "}";
        }
    }
}

