/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.numerics.movingaverages;

import io.deephaven.numerics.movingaverages.AbstractMa;
import java.io.Serializable;

public class Ema
extends AbstractMa
implements Serializable {
    private static final long serialVersionUID = 5997048575951664518L;
    private double emaState = Double.NaN;
    private boolean initialized = false;

    public Ema(AbstractMa.Type type, AbstractMa.Mode mode, double timeScale) {
        super(type, mode, timeScale);
    }

    @Override
    protected void processDoubleLocal(long timestamp, double data) {
        long dt;
        if (!this.initialized) {
            switch (this.type) {
                case LEVEL: {
                    this.emaState = data;
                    break;
                }
                case DIFFERENCE: {
                    this.emaState = 0.0;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Ema type is not yet supported: " + this.type);
                }
            }
            this.initialized = true;
        }
        switch (this.mode) {
            case TICK: {
                dt = 1L;
                break;
            }
            case TIME: {
                dt = timestamp - this.lastTimestamp;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Ema mode is not yet supported: " + this.mode);
            }
        }
        double dtLimited = dt < 0L ? 0.0 : (double)dt;
        double alpha = Math.exp(-dtLimited / this.timeScale);
        this.emaState = alpha * this.emaState + (1.0 - alpha) * data;
    }

    @Override
    public double getCurrent() {
        return this.emaState;
    }

    @Override
    public void setCurrent(double value) {
        this.emaState = value;
    }

    @Override
    public void reset() {
        this.initialized = false;
        this.emaState = Double.NaN;
        this.lastTimestamp = Long.MIN_VALUE;
    }
}

