/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.numerics.movingaverages;

import io.deephaven.numerics.movingaverages.AbstractMa;
import io.deephaven.numerics.movingaverages.Ema;
import java.io.Serializable;

public class EmaArray
implements Serializable {
    private static final long serialVersionUID = 2127279097359961192L;
    private final Ema[] emas;
    private long lastTimestamp = Long.MIN_VALUE;
    private double lastSample = Double.NaN;

    public EmaArray(AbstractMa.Type type, AbstractMa.Mode mode, double[] timeScales) {
        this.emas = new Ema[timeScales.length];
        for (int i = 0; i < timeScales.length; ++i) {
            this.emas[i] = new Ema(type, mode, timeScales[i]);
        }
    }

    public void processDouble(long timestamp, double data) {
        for (Ema ema : this.emas) {
            ema.processDouble(timestamp, data);
        }
        this.lastTimestamp = timestamp;
        this.lastSample = data;
    }

    public void reset() {
        for (Ema ema : this.emas) {
            ema.reset();
        }
    }

    public double[] getCurrent() {
        double[] result = new double[this.emas.length];
        for (int i = 0; i < this.emas.length; ++i) {
            result[i] = this.emas[i].getCurrent();
        }
        return result;
    }

    public int size() {
        return this.emas.length;
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public double getLastSample() {
        return this.lastSample;
    }
}

