/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.numerics.movingaverages;

import java.io.Serializable;

public class ExponentiallyDecayedSum
implements Serializable {
    private static final long serialVersionUID = -4569122361884129319L;
    private final double decayRate;
    private final boolean enableTimestepOutOfOrderException;
    private long lastTimestamp = Long.MIN_VALUE;
    private double value = 0.0;

    public ExponentiallyDecayedSum(double decayRate, boolean enableTimestepOutOfOrderException) {
        this.decayRate = decayRate;
        this.enableTimestepOutOfOrderException = enableTimestepOutOfOrderException;
    }

    public void processDouble(long timestamp, double data) {
        long dt = Math.max(timestamp - this.lastTimestamp, 0L);
        if (this.enableTimestepOutOfOrderException && this.lastTimestamp != Long.MIN_VALUE && dt < 0L) {
            throw new IllegalStateException("Timesteps are out of order: timestamps=" + this.lastTimestamp + "," + timestamp);
        }
        double weight = Math.exp((double)(-dt) / this.decayRate);
        this.value = this.lastTimestamp == Long.MIN_VALUE ? data : data + weight * this.value;
        this.lastTimestamp = timestamp;
    }

    public double getValue() {
        return this.value;
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void reset() {
        this.lastTimestamp = Long.MIN_VALUE;
        this.value = 0.0;
    }
}

