/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stats;

import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;
import io.deephaven.base.stats.State;
import io.deephaven.base.stats.Stats;
import io.deephaven.base.stats.Value;
import io.deephaven.hash.KeyedObjectHash;
import io.deephaven.hash.KeyedObjectKey;
import java.util.Objects;
import java.util.function.LongFunction;

public class ObjectAllocationCollector {
    public static boolean DUMP_STACK;
    public static String[] CLASS_NAMES;
    private final KeyedObjectHash<Class, AllocationState> classAllocationStates = new KeyedObjectHash(AllocationState.keyDef);
    private final KeyedObjectHash.ValueFactoryT<Class, AllocationState, Value> STATE_FACTORY = new KeyedObjectHash.ValueFactoryT<Class, AllocationState, Value>(){

        public AllocationState newValue(Class key, Value value) {
            return new AllocationState(value, key);
        }
    };

    public ObjectAllocationCollector() {
        AllocationRecorder.addSampler((Sampler)new Sampler(){

            public void sampleAllocation(int count, String desc, Object newObj, long size) {
                Class<?> clazz = newObj.getClass();
                if (clazz.getName().startsWith("sun.") || clazz.getName().endsWith("AllocationState")) {
                    return;
                }
                AllocationState allocationState = (AllocationState)ObjectAllocationCollector.this.classAllocationStates.get(clazz);
                if (allocationState == null) {
                    Value value = Stats.makeItem((String)"GAllocation", (String)clazz.getName(), (LongFunction)State.FACTORY).getValue();
                    AllocationState state = new AllocationState(value, clazz);
                    AllocationState existing = (AllocationState)ObjectAllocationCollector.this.classAllocationStates.putIfAbsent(clazz, (Object)state);
                    (existing == null ? state : existing).sample(size);
                } else {
                    allocationState.sample(size);
                }
            }
        });
    }

    static {
        String sEnable;
        DUMP_STACK = false;
        String sClassNames = System.getProperty("ObjectAllocationCollector.dumpStackForClasses");
        if (null != sClassNames) {
            CLASS_NAMES = sClassNames.split(",");
            int nLength = CLASS_NAMES.length;
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                ObjectAllocationCollector.CLASS_NAMES[nIndex] = CLASS_NAMES[nIndex].intern();
            }
        } else {
            CLASS_NAMES = new String[0];
        }
        if (null != (sEnable = System.getProperty("ObjectAllocationCollector.dumpStack")) && (sEnable.toLowerCase().contains("y") || sEnable.toLowerCase().contains("t"))) {
            DUMP_STACK = true;
        }
    }

    private static class AllocationState {
        private final Value size;
        private final Class clazz;
        private Boolean dumpStack;
        public static KeyedObjectKey<Class, AllocationState> keyDef = new KeyedObjectKey<Class, AllocationState>(){

            protected KeyedObjectKey clone() throws CloneNotSupportedException {
                return (KeyedObjectKey)super.clone();
            }

            public Class getKey(AllocationState v) {
                return v.clazz;
            }

            public int hashKey(Class k) {
                return k.hashCode();
            }

            public boolean equalKey(Class k, AllocationState v) {
                return k.equals(v.clazz);
            }
        };

        private AllocationState(Value size, Class clazz) {
            this.size = size;
            this.clazz = clazz;
        }

        public void sample(long bytes) {
            if (this.size != null) {
                this.size.sample(bytes);
            }
            if (null == this.dumpStack) {
                if (null != CLASS_NAMES) {
                    for (String sClassName : CLASS_NAMES) {
                        if (!Objects.equals(sClassName, this.clazz.getName())) continue;
                        this.dumpStack = Boolean.TRUE;
                        return;
                    }
                    this.dumpStack = Boolean.FALSE;
                }
                return;
            }
            if (DUMP_STACK && this.dumpStack.booleanValue()) {
                new Throwable().printStackTrace();
            }
        }
    }
}

