/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stats;

import io.deephaven.base.stats.Counter;
import io.deephaven.base.stats.State;
import io.deephaven.base.stats.Stats;
import io.deephaven.base.verify.Assert;
import io.deephaven.configuration.Configuration;
import io.deephaven.hash.KeyedLongObjectHash;
import io.deephaven.hash.KeyedLongObjectHashMap;
import io.deephaven.hash.KeyedLongObjectKey;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.stats.util.OSUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.LongFunction;

public class StatsCPUCollector {
    private static final Logger log = LoggerFactory.getLogger(StatsCPUCollector.class);
    public static final boolean MEASURE_PER_THREAD_CPU = Configuration.getInstance().getBoolean("measurement.per_thread_cpu");
    private static final String PROC_STAT_PSEUDOFILE = "/proc/stat";
    private static final String PROC_SELF_STAT_PSEUDOFILE = "/proc/self/stat";
    private static final String PROC_STAT_FD_PSUEDOFILE = "/proc/self/fd";
    private static final long NANOS = 1000000000L;
    private static final long MILLIS = 1000L;
    private final long divisor;
    private boolean hasProcStat = true;
    private boolean hasProcPidStat = true;
    private boolean hasProcFd = true;
    private Counter statSysUserJiffies = null;
    private Counter statSysSystemJiffies = null;
    private Counter statSysIOWait = null;
    private Counter statSysPageIn = null;
    private Counter statSysPageOut = null;
    private Counter statSysSwapIn = null;
    private Counter statSysSwapOut = null;
    private Counter statSysInterrupts = null;
    private Counter statSysCtxt = null;
    private Counter statProcMinorFaults = null;
    private Counter statProcMajorFaults = null;
    private Counter statProcUserJiffies = null;
    private Counter statProcSystemJiffies = null;
    private State statProcVSZ = null;
    private State statProcRSS = null;
    private State statProcNumFDs = null;
    private State statProcMaxFD = null;
    private ByteBuffer statBuffer = null;
    private final long interval;
    private final boolean getFdStats;
    private static final KeyedLongObjectHashMap<ThreadState> threadStates = new KeyedLongObjectHashMap(100, ThreadState.keyDef);
    private State processUserTime;
    private State processSystemTime;
    private FileChannel statFile;
    private FileChannel procFile;

    StatsCPUCollector(long interval, boolean getFdStats) {
        this.interval = interval;
        this.getFdStats = getFdStats;
        long seconds = interval / 1000L;
        this.divisor = 1000000000L / (seconds * 10L);
        Stats.makeGroup((String)"Kernel", (String)"Unix kernel statistics, as read from /proc/stat");
        Stats.makeGroup((String)"Proc", (String)"Unix process statistics, as read from /proc/self/stat and /proc/self/fd");
        Stats.makeGroup((String)"CPU", (String)"JMX CPU usage data, per-thread and for the entire process");
        if (OSUtil.runningMacOS() || OSUtil.runningWindows()) {
            this.hasProcStat = false;
            this.hasProcPidStat = false;
            this.hasProcFd = false;
        }
    }

    private boolean startsWith(String match) {
        if (match.length() > this.statBuffer.remaining()) {
            return false;
        }
        for (int i = 0; i < match.length(); ++i) {
            int nextIdx = i + this.statBuffer.position();
            if (this.statBuffer.get(nextIdx) == match.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean skipWhiteSpace() {
        while (this.statBuffer.hasRemaining() && this.statBuffer.get(this.statBuffer.position()) == 32) {
            this.statBuffer.position(this.statBuffer.position() + 1);
        }
        return this.statBuffer.hasRemaining();
    }

    private boolean skipNextField() {
        while (this.statBuffer.hasRemaining() && this.statBuffer.get(this.statBuffer.position()) != 32) {
            if (this.statBuffer.get(this.statBuffer.position()) == 10) {
                return false;
            }
            this.statBuffer.position(this.statBuffer.position() + 1);
        }
        return this.skipWhiteSpace();
    }

    private void getNextFieldSampleKilobytes(State v) {
        v.sample(this.getNextFieldLong() / 1024L);
        this.skipWhiteSpace();
    }

    private boolean getNextFieldDeltaJiffies(Counter v) {
        v.incrementFromSample(this.getNextFieldLong() * 10000L / this.interval);
        return this.skipWhiteSpace();
    }

    private boolean getNextFieldDelta(Counter v) {
        v.incrementFromSample(this.getNextFieldLong());
        return this.skipWhiteSpace();
    }

    private void getNextFieldSample(State v) {
        v.sample(this.getNextFieldLong());
        this.skipWhiteSpace();
    }

    private long getNextFieldLong() {
        long result = 0L;
        while (this.peekNextLong()) {
            result *= 10L;
            result += (long)(this.statBuffer.get() - 48);
        }
        return result;
    }

    private boolean peekNextLong() {
        return this.statBuffer.hasRemaining() && this.statBuffer.get(this.statBuffer.position()) >= 48 && this.statBuffer.get(this.statBuffer.position()) <= 57;
    }

    private void readToBuffer(FileChannel fileChannel, String fileName) throws IOException {
        this.statBuffer.clear();
        fileChannel.position(0L);
        while (true) {
            int nb;
            if ((nb = fileChannel.read(this.statBuffer)) <= 0) {
                throw new IOException(fileName + " could not be read, or was empty");
            }
            if (this.statBuffer.hasRemaining()) {
                Assert.eq((int)this.statBuffer.position(), (String)"statBuffer.position()", (int)nb, (String)"nb");
                this.statBuffer.flip();
                return;
            }
            this.statBuffer = ByteBuffer.allocate(this.statBuffer.capacity() * 2);
            fileChannel.position(0L);
        }
    }

    private void updateSys() {
        if (this.hasProcStat) {
            try {
                if (this.statFile == null) {
                    this.statFile = FileChannel.open(Path.of(PROC_STAT_PSEUDOFILE, new String[0]), new OpenOption[0]);
                }
                this.readToBuffer(this.statFile, PROC_STAT_PSEUDOFILE);
                while (this.statBuffer.hasRemaining()) {
                    while (this.statBuffer.hasRemaining() && this.statBuffer.get(this.statBuffer.position()) < 33) {
                        this.statBuffer.position(this.statBuffer.position() + 1);
                    }
                    if (this.startsWith("cpu ")) {
                        if (this.skipNextField() && this.peekNextLong()) {
                            if (this.statSysUserJiffies == null) {
                                this.statSysUserJiffies = (Counter)Stats.makeItem((String)"Kernel", (String)"UserJiffies", (LongFunction)Counter.FACTORY, (String)"User jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                                this.statSysSystemJiffies = (Counter)Stats.makeItem((String)"Kernel", (String)"SystemJiffies", (LongFunction)Counter.FACTORY, (String)"System jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                            }
                            if (this.getNextFieldDeltaJiffies(this.statSysUserJiffies) && this.skipNextField() && this.peekNextLong() && this.getNextFieldDeltaJiffies(this.statSysSystemJiffies) && this.skipNextField() && this.skipNextField() && this.peekNextLong()) {
                                if (this.statSysIOWait == null) {
                                    this.statSysIOWait = (Counter)Stats.makeItem((String)"Kernel", (String)"IOWait", (LongFunction)Counter.FACTORY, (String)"IOWait jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                                }
                                this.getNextFieldDeltaJiffies(this.statSysIOWait);
                            }
                        }
                    } else if (this.startsWith("page")) {
                        if (this.skipNextField() && this.peekNextLong()) {
                            if (this.statSysPageIn == null) {
                                this.statSysPageIn = (Counter)Stats.makeItem((String)"Kernel", (String)"PageIn", (LongFunction)Counter.FACTORY, (String)"Number of pages read in from disk").getValue();
                                this.statSysPageOut = (Counter)Stats.makeItem((String)"Kernel", (String)"PageOut", (LongFunction)Counter.FACTORY, (String)"Number of pages written to disk").getValue();
                            }
                            if (this.getNextFieldDelta(this.statSysPageIn) && this.peekNextLong()) {
                                this.getNextFieldDelta(this.statSysPageOut);
                            }
                        }
                    } else if (this.startsWith("swap")) {
                        if (this.statSysSwapIn == null) {
                            this.statSysSwapIn = (Counter)Stats.makeItem((String)"Kernel", (String)"SwapIn", (LongFunction)Counter.FACTORY, (String)"Number of pages read from swap space").getValue();
                            this.statSysSwapOut = (Counter)Stats.makeItem((String)"Kernel", (String)"SwapOut", (LongFunction)Counter.FACTORY, (String)"Number of pages written to swap space").getValue();
                        }
                        if (this.skipNextField() && this.getNextFieldDelta(this.statSysSwapIn) && this.peekNextLong()) {
                            this.getNextFieldDelta(this.statSysSwapOut);
                        }
                    } else if (this.startsWith("intr")) {
                        if (this.statSysInterrupts == null) {
                            this.statSysInterrupts = (Counter)Stats.makeItem((String)"Kernel", (String)"Interrupts", (LongFunction)Counter.FACTORY, (String)"Number of interrupts").getValue();
                        }
                        if (this.skipNextField()) {
                            this.getNextFieldDelta(this.statSysInterrupts);
                        }
                    } else if (this.startsWith("ctxt")) {
                        if (this.statSysCtxt == null) {
                            this.statSysCtxt = (Counter)Stats.makeItem((String)"Kernel", (String)"Ctxt", (LongFunction)Counter.FACTORY, (String)"Number of context switches").getValue();
                        }
                        if (this.skipNextField()) {
                            this.getNextFieldDelta(this.statSysCtxt);
                        }
                    }
                    while (this.statBuffer.hasRemaining() && this.statBuffer.get() != 10) {
                    }
                }
            }
            catch (Exception x) {
                if (this.statFile != null) {
                    try {
                        this.statFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.statFile = null;
                }
                if (this.hasProcStat) {
                    log.error((Object)("got an exception reading /proc/stat: " + x));
                }
                this.hasProcStat = false;
            }
        }
    }

    private void updateProc() {
        if (this.hasProcPidStat) {
            try {
                int i;
                if (this.procFile == null) {
                    this.procFile = FileChannel.open(Path.of(PROC_SELF_STAT_PSEUDOFILE, new String[0]), new OpenOption[0]);
                }
                if (this.statProcMinorFaults == null) {
                    this.statProcMinorFaults = (Counter)Stats.makeItem((String)"Proc", (String)"MinorFaults", (LongFunction)Counter.FACTORY, (String)"Minor faults the process has incurred").getValue();
                    this.statProcMajorFaults = (Counter)Stats.makeItem((String)"Proc", (String)"MajorFaults", (LongFunction)Counter.FACTORY, (String)"Major faults the process has incurred").getValue();
                    this.statProcUserJiffies = (Counter)Stats.makeItem((String)"Proc", (String)"UserJiffies", (LongFunction)Counter.FACTORY, (String)"User jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                    this.statProcSystemJiffies = (Counter)Stats.makeItem((String)"Proc", (String)"SystemJiffies", (LongFunction)Counter.FACTORY, (String)"System jiffies per 10 second interval (1000 equals 1 full CPU)").getValue();
                    this.statProcVSZ = (State)Stats.makeItem((String)"Proc", (String)"VSZ", (LongFunction)State.FACTORY, (String)"Virtual size of the process in kilobytes").getValue();
                    this.statProcRSS = (State)Stats.makeItem((String)"Proc", (String)"RSS", (LongFunction)State.FACTORY, (String)"Resident set size of the process in pages").getValue();
                }
                this.readToBuffer(this.procFile, PROC_SELF_STAT_PSEUDOFILE);
                for (i = 0; i < 9; ++i) {
                    this.skipNextField();
                }
                this.getNextFieldDelta(this.statProcMinorFaults);
                this.skipNextField();
                this.getNextFieldDelta(this.statProcMajorFaults);
                this.skipNextField();
                this.getNextFieldDeltaJiffies(this.statProcUserJiffies);
                this.getNextFieldDeltaJiffies(this.statProcSystemJiffies);
                for (i = 15; i < 22; ++i) {
                    this.skipNextField();
                }
                this.getNextFieldSampleKilobytes(this.statProcVSZ);
                this.getNextFieldSample(this.statProcRSS);
            }
            catch (Exception x) {
                if (this.procFile != null) {
                    try {
                        this.procFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.procFile = null;
                }
                if (this.hasProcPidStat) {
                    log.error((Object)("got an exception reading /proc/self/stat: " + x));
                }
                this.hasProcPidStat = false;
            }
        }
    }

    private void updateProcFD() {
        if (this.hasProcFd) {
            try {
                File procFd = new File(PROC_STAT_FD_PSUEDOFILE);
                String[] entries = procFd.list();
                if (entries == null) {
                    this.hasProcFd = false;
                    return;
                }
                if (this.statProcNumFDs == null) {
                    this.statProcNumFDs = (State)Stats.makeItem((String)"Proc", (String)"NumFDs", (LongFunction)State.FACTORY, (String)"Number of open file descriptors in the process").getValue();
                    this.statProcMaxFD = (State)Stats.makeItem((String)"Proc", (String)"MaxFD", (LongFunction)State.FACTORY, (String)"Highest-numbered file descriptors in the process").getValue();
                }
                int maxFd = -1;
                for (String s : entries) {
                    try {
                        int fd = Integer.parseInt(s);
                        maxFd = Math.max(fd, maxFd);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.statProcNumFDs.sample((long)entries.length);
                this.statProcMaxFD.sample((long)maxFd);
            }
            catch (Exception x) {
                this.hasProcFd = false;
            }
        }
    }

    private void updatePerThreadCPU() {
        if (MEASURE_PER_THREAD_CPU) {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            long[] threadIds = threadMXBean.getAllThreadIds();
            ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadIds);
            long deltaProcessCpuTime = 0L;
            long deltaProcessUserTime = 0L;
            for (ThreadInfo tinfo : threadInfos) {
                if (tinfo == null) continue;
                ThreadState state = (ThreadState)threadStates.putIfAbsent(tinfo.getThreadId(), ThreadState.factory);
                long cpuTime = threadMXBean.getThreadCpuTime(state.id);
                long userTime = threadMXBean.getThreadUserTime(state.id);
                if (state.name == null) {
                    state.name = tinfo.getThreadName();
                    state.userTime = (State)Stats.makeItem((String)"CPU", (String)(state.name + "-userTime"), (LongFunction)State.FACTORY, (String)"Per-thread CPU usage in user mode, 1000 equals 1 full CPU, as reported by Java").getValue();
                    state.systemTime = (State)Stats.makeItem((String)"CPU", (String)(state.name + "-systemTime"), (LongFunction)State.FACTORY, (String)"Per-thread CPU usage in system mode, 1000 equals 1 full CPU, as reported by Java").getValue();
                } else {
                    long deltaCpuTime = cpuTime - state.lastCpuTime;
                    long deltaUserTime = userTime - state.lastUserTime;
                    deltaProcessCpuTime += deltaCpuTime;
                    deltaProcessUserTime += deltaUserTime;
                    if (deltaUserTime / this.divisor != 0L) {
                        state.userTime.sample(deltaUserTime / this.divisor);
                    }
                    if ((deltaCpuTime - deltaUserTime) / this.divisor != 0L) {
                        state.systemTime.sample((deltaCpuTime - deltaUserTime) / this.divisor);
                    }
                }
                state.lastCpuTime = cpuTime;
                state.lastUserTime = userTime;
            }
            if (this.processUserTime == null) {
                this.processUserTime = (State)Stats.makeItem((String)"CPU", (String)"process-userTime", (LongFunction)State.FACTORY, (String)"Process CPU usage in user mode, 1000 equals 1 full CPU, as reported by JMX").getValue();
                this.processSystemTime = (State)Stats.makeItem((String)"CPU", (String)"process-systemTime", (LongFunction)State.FACTORY, (String)"Process CPU usage in system mode, 1000 equals 1 full CPU, as reported by JMX").getValue();
            }
            this.processUserTime.sample(deltaProcessUserTime / this.divisor);
            this.processSystemTime.sample((deltaProcessCpuTime - deltaProcessUserTime) / this.divisor);
        }
    }

    public void update() {
        if (this.statBuffer == null) {
            this.statBuffer = ByteBuffer.allocate(4096);
        }
        this.updateSys();
        this.updateProc();
        if (this.getFdStats) {
            this.updateProcFD();
        }
        this.updatePerThreadCPU();
    }

    private static class ThreadState {
        private final long id;
        private String name;
        private long lastCpuTime;
        private long lastUserTime;
        private State userTime;
        private State systemTime;
        public static KeyedLongObjectKey<ThreadState> keyDef = new KeyedLongObjectKey<ThreadState>(){

            public Long getKey(ThreadState v) {
                return v.id;
            }

            public long getLongKey(ThreadState v) {
                return v.id;
            }

            public int hashKey(Long k) {
                return (int)k.longValue();
            }

            public int hashLongKey(long k) {
                return (int)k;
            }

            public boolean equalKey(Long k, ThreadState v) {
                return k == v.id;
            }

            public boolean equalLongKey(long k, ThreadState v) {
                return k == v.id;
            }
        };
        public static KeyedLongObjectHash.ValueFactory<ThreadState> factory = new KeyedLongObjectHash.ValueFactory<ThreadState>(){

            public ThreadState newValue(long key) {
                return new ThreadState(key);
            }

            public ThreadState newValue(Long key) {
                return new ThreadState(key);
            }
        };

        public ThreadState(long id) {
            this.id = id;
        }
    }
}

