/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tablelogger;

import io.deephaven.base.stats.Counter;
import io.deephaven.base.stats.Stats;
import io.deephaven.base.stats.Value;
import io.deephaven.base.system.AsyncSystem;
import io.deephaven.base.system.PrintStreamGlobals;
import io.deephaven.tablelogger.Row;
import io.deephaven.tablelogger.TableLogger;
import io.deephaven.tablelogger.TableWriter;
import io.deephaven.tablelogger.WritableRowContainer;
import io.deephaven.util.pool.PoolEx;
import io.deephaven.util.pool.ThreadSafeFixedSizePool;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongFunction;

public abstract class TableLoggerImpl2<T extends WritableRowContainer>
implements TableLogger {
    protected TableWriter writer;
    protected PoolEx<T> setterPool;
    protected volatile boolean isClosed;
    protected volatile boolean isShuttingDown;
    private boolean initialized = false;
    protected final AtomicInteger outstandingSetters = new AtomicInteger(0);
    private volatile boolean isWriting = false;
    private final Value writtenCount;
    private static final int EXIT_STATUS = 1;
    private static final PrintStream err = PrintStreamGlobals.getErr();

    public TableLoggerImpl2(String tablename) {
        Objects.requireNonNull(tablename);
        String loggerName = "Logger--" + tablename;
        this.writtenCount = Stats.makeItem((String)loggerName, (String)"writtenCount", (LongFunction)Counter.FACTORY).getValue();
    }

    @Override
    public final synchronized void init(TableWriter tableWriter, int queueSize) throws IOException {
        if (this.initialized) {
            return;
        }
        this.writer = tableWriter;
        this.setterPool = new ThreadSafeFixedSizePool(queueSize, this::createSetter, null);
        this.initialized = true;
    }

    protected abstract T createSetter();

    protected abstract String threadName();

    protected final boolean isInitialized() {
        return this.initialized;
    }

    protected final void verifyCondition(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    @Override
    public final void shutdown() {
        this.isShuttingDown = true;
        while (this.outstandingSetters.getAndDecrement() > 0) {
            this.setterPool.take();
        }
    }

    private void exit(Throwable t) {
        AsyncSystem.exitCaught((Thread)Thread.currentThread(), (Throwable)t, (int)1, (PrintStream)err, (String)"Unable to write log entry");
    }

    protected final void flush(T setter) {
        try {
            this.tryWrite(setter);
        }
        catch (IOException x) {
            if (this.isClosed()) {
                err.println(String.format("TableLogger.flush: caught exception in thread %s. Unable to write log entry. Logger already closed, not invoking shutdown.", Thread.currentThread().getName()));
                x.printStackTrace(err);
            } else {
                this.exit(x);
            }
        }
        catch (Throwable t) {
            this.exit(t);
        }
    }

    public final void waitDone() {
        while (this.notDone()) {
            LockSupport.parkNanos(1000000L);
        }
    }

    public final boolean waitDone(long millis) {
        long endTime = System.currentTimeMillis() + millis;
        while (endTime > System.currentTimeMillis() && this.notDone()) {
            LockSupport.parkNanos(1000000L);
        }
        return !this.notDone();
    }

    private boolean notDone() {
        return !this.isClosed && this.isWriting;
    }

    @Override
    public final void close() throws IOException {
        this.isClosed = true;
        this.writer.close();
    }

    @Override
    public final boolean isClosed() {
        return this.isClosed;
    }

    private void tryWrite(T setter) throws IOException {
        this.isWriting = true;
        try {
            if (this.isClosed) {
                return;
            }
            setter.writeRow();
            setter.release();
            this.writtenCount.increment(1L);
        }
        finally {
            this.isWriting = false;
        }
    }

    public abstract class BaseSetter<T2 extends BaseSetter<T2>>
    implements WritableRowContainer {
        protected Row row;
        protected T2 next;

        public T2 getNext() {
            return this.next;
        }

        public void setNext(T2 other) {
            this.next = other;
        }

        protected BaseSetter() {
            this.row = TableLoggerImpl2.this.writer.getRowWriter();
        }

        public Row getRow() {
            return this.row;
        }

        protected void setRowFlags(Row.Flags rowFlags) {
            this.row.setFlags(rowFlags);
        }

        @Override
        public void writeRow() throws IOException {
            this.row.writeRow();
        }

        @Override
        public void release() {
            TableLoggerImpl2.this.setterPool.give((Object)this);
        }
    }
}

