/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.tablelogger;

import io.deephaven.tablelogger.RowSetter;
import io.deephaven.util.type.TypeUtils;
import java.io.IOException;

public interface Row {
    public RowSetter getSetter(String var1);

    default public <T> RowSetter<T> getSetter(String name, Class<T> tClass) {
        Class unboxedType;
        RowSetter setter = this.getSetter(name);
        if (tClass.isAssignableFrom(setter.getType()) || (unboxedType = TypeUtils.getUnboxedType(tClass)) != null && unboxedType.isAssignableFrom(setter.getType())) {
            return setter;
        }
        throw new ClassCastException(name + " is of type " + setter.getType() + ", not of type " + tClass + (String)(unboxedType == null ? "" : " or " + unboxedType));
    }

    public void writeRow() throws IOException;

    @Deprecated
    public long size();

    public void setFlags(Flags var1);

    default public void setColumnPartitionValue(String columnPartitionValue) {
        throw new UnsupportedOperationException("Default Row implementation does not support setColumnPartitionValue()");
    }

    default public String getColumnPartitionValue() {
        throw new UnsupportedOperationException("Default Row implementation does not support getColumnPartitionValue()");
    }

    public static enum Flags {
        None,
        StartTransaction,
        EndTransaction,
        SingleRow;

    }
}

